package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class StatsBuilder extends StatsFluentImpl<StatsBuilder> implements VisitableBuilder<Stats,StatsBuilder>{

    StatsFluent<?> fluent;
    Boolean validationEnabled;

    public StatsBuilder(){
            this(true);
    }
    public StatsBuilder(Boolean validationEnabled){
            this(new Stats(), validationEnabled);
    }
    public StatsBuilder(StatsFluent<?> fluent){
            this(fluent, true);
    }
    public StatsBuilder(StatsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Stats(), validationEnabled);
    }
    public StatsBuilder(StatsFluent<?> fluent,Stats instance){
            this(fluent, instance, true);
    }
    public StatsBuilder(StatsFluent<?> fluent,Stats instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBlkioStats(instance.getBlkioStats()); 
            fluent.withCpuStats(instance.getCpuStats()); 
            fluent.withMemoryStats(instance.getMemoryStats()); 
            fluent.withPrecpuStats(instance.getPrecpuStats()); 
            fluent.withRead(instance.getRead()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatsBuilder(Stats instance){
            this(instance,true);
    }
    public StatsBuilder(Stats instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBlkioStats(instance.getBlkioStats()); 
            this.withCpuStats(instance.getCpuStats()); 
            this.withMemoryStats(instance.getMemoryStats()); 
            this.withPrecpuStats(instance.getPrecpuStats()); 
            this.withRead(instance.getRead()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableStats build(){
            EditableStats buildable = new EditableStats(fluent.getBlkioStats(),fluent.getCpuStats(),fluent.getMemoryStats(),fluent.getPrecpuStats(),fluent.getRead());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatsBuilder that = (StatsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
