package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class ServiceConfigFluentImpl<A extends ServiceConfigFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ServiceConfigFluent<A>{

    private Map<String,IndexInfo> IndexConfigs = new LinkedHashMap<String,IndexInfo>();
    private List<VisitableBuilder<? extends NetIPNet,?>> InsecureRegistryCIDRs =  new ArrayList<VisitableBuilder<? extends NetIPNet,?>>();
    private List<String> Mirrors = new ArrayList<String>();

    public ServiceConfigFluentImpl(){
    }
    public ServiceConfigFluentImpl(ServiceConfig instance){
            this.withIndexConfigs(instance.getIndexConfigs()); 
            this.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs()); 
            this.withMirrors(instance.getMirrors()); 
    }

    public A addToIndexConfigs(String key,IndexInfo value){
            if(key != null && value != null) {this.IndexConfigs.put(key, value);} return (A)this;
    }

    public A addToIndexConfigs(Map<String,IndexInfo> map){
            if(map != null) { this.IndexConfigs.putAll(map);} return (A)this;
    }

    public A removeFromIndexConfigs(String key){
            if(key != null) {this.IndexConfigs.remove(key);} return (A)this;
    }

    public A removeFromIndexConfigs(Map<String,IndexInfo> map){
            if(map != null) { for(Object key : map.keySet()) {this.IndexConfigs.remove(key);}} return (A)this;
    }

    public Map<String,IndexInfo> getIndexConfigs(){
            return this.IndexConfigs;
    }

    public A withIndexConfigs(Map<String,IndexInfo> IndexConfigs){
            this.IndexConfigs.clear();
            if (IndexConfigs != null) {this.IndexConfigs.putAll(IndexConfigs);} return (A) this;
    }

    public A addToInsecureRegistryCIDRs(NetIPNet... items){
            for (NetIPNet item : items) {NetIPNetBuilder builder = new NetIPNetBuilder(item);_visitables.add(builder);this.InsecureRegistryCIDRs.add(builder);} return (A)this;
    }

    public A removeFromInsecureRegistryCIDRs(NetIPNet... items){
            for (NetIPNet item : items) {NetIPNetBuilder builder = new NetIPNetBuilder(item);_visitables.remove(builder);this.InsecureRegistryCIDRs.remove(builder);} return (A)this;
    }

    public List<NetIPNet> getInsecureRegistryCIDRs(){
            return build(InsecureRegistryCIDRs);
    }

    public A withInsecureRegistryCIDRs(List<NetIPNet> InsecureRegistryCIDRs){
            _visitables.removeAll(this.InsecureRegistryCIDRs);
            this.InsecureRegistryCIDRs.clear();
            if (InsecureRegistryCIDRs != null) {for (NetIPNet item : InsecureRegistryCIDRs){this.addToInsecureRegistryCIDRs(item);}} return (A) this;
    }

    public A withInsecureRegistryCIDRs(NetIPNet... InsecureRegistryCIDRs){
            this.InsecureRegistryCIDRs.clear(); if (InsecureRegistryCIDRs != null) {for (NetIPNet item :InsecureRegistryCIDRs){ this.addToInsecureRegistryCIDRs(item);}} return (A) this;
    }

    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDR(){
            return new InsecureRegistryCIDRsNestedImpl();
    }

    public ServiceConfigFluent.InsecureRegistryCIDRsNested<A> addNewInsecureRegistryCIDRLike(NetIPNet item){
            return new InsecureRegistryCIDRsNestedImpl(item);
    }

    public A addNewInsecureRegistryCIDR(String ip,String mask){
            return (A)addToInsecureRegistryCIDRs(new NetIPNet(ip, mask));
    }

    public A addNewInsecureRegistryCIDR(String s){
            return (A)addToInsecureRegistryCIDRs(new NetIPNet(s));
    }

    public A addToMirrors(String... items){
            for (String item : items) {this.Mirrors.add(item);} return (A)this;
    }

    public A removeFromMirrors(String... items){
            for (String item : items) {this.Mirrors.remove(item);} return (A)this;
    }

    public List<String> getMirrors(){
            return this.Mirrors;
    }

    public A withMirrors(List<String> Mirrors){
            this.Mirrors.clear();
            if (Mirrors != null) {for (String item : Mirrors){this.addToMirrors(item);}} return (A) this;
    }

    public A withMirrors(String... Mirrors){
            this.Mirrors.clear(); if (Mirrors != null) {for (String item :Mirrors){ this.addToMirrors(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceConfigFluentImpl that = (ServiceConfigFluentImpl) o;
            if (IndexConfigs != null ? !IndexConfigs.equals(that.IndexConfigs) :that.IndexConfigs != null) return false;
            if (InsecureRegistryCIDRs != null ? !InsecureRegistryCIDRs.equals(that.InsecureRegistryCIDRs) :that.InsecureRegistryCIDRs != null) return false;
            if (Mirrors != null ? !Mirrors.equals(that.Mirrors) :that.Mirrors != null) return false;
            return true;
    }


    public class InsecureRegistryCIDRsNestedImpl<N> extends NetIPNetFluentImpl<ServiceConfigFluent.InsecureRegistryCIDRsNested<N>> implements ServiceConfigFluent.InsecureRegistryCIDRsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetIPNetBuilder builder;
    
            InsecureRegistryCIDRsNestedImpl(NetIPNet item){
                    this.builder = new NetIPNetBuilder(this, item);
            }
            InsecureRegistryCIDRsNestedImpl(){
                    this.builder = new NetIPNetBuilder(this);
            }
    
    public N and(){
            return (N) ServiceConfigFluentImpl.this.addToInsecureRegistryCIDRs(builder.build());
    }
    public N endInsecureRegistryCIDR(){
            return and();
    }

}


}
