package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ServiceConfigBuilder extends ServiceConfigFluentImpl<ServiceConfigBuilder> implements VisitableBuilder<ServiceConfig,ServiceConfigBuilder>{

    ServiceConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceConfigBuilder(){
            this(true);
    }
    public ServiceConfigBuilder(Boolean validationEnabled){
            this(new ServiceConfig(), validationEnabled);
    }
    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceConfig(), validationEnabled);
    }
    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent,ServiceConfig instance){
            this(fluent, instance, true);
    }
    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent,ServiceConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIndexConfigs(instance.getIndexConfigs()); 
            fluent.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs()); 
            fluent.withMirrors(instance.getMirrors()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceConfigBuilder(ServiceConfig instance){
            this(instance,true);
    }
    public ServiceConfigBuilder(ServiceConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIndexConfigs(instance.getIndexConfigs()); 
            this.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs()); 
            this.withMirrors(instance.getMirrors()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableServiceConfig build(){
            EditableServiceConfig buildable = new EditableServiceConfig(fluent.getIndexConfigs(),fluent.getInsecureRegistryCIDRs(),fluent.getMirrors());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceConfigBuilder that = (ServiceConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
