package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class SearchResultsFluentImpl<A extends SearchResultsFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements SearchResultsFluent<A>{

    private Integer numResults;
    private String query;
    private List<VisitableBuilder<? extends SearchResult,?>> results =  new ArrayList<VisitableBuilder<? extends SearchResult,?>>();

    public SearchResultsFluentImpl(){
    }
    public SearchResultsFluentImpl(SearchResults instance){
            this.withNumResults(instance.getNumResults()); 
            this.withQuery(instance.getQuery()); 
            this.withResults(instance.getResults()); 
    }

    public Integer getNumResults(){
            return this.numResults;
    }

    public A withNumResults(Integer numResults){
            this.numResults=numResults; return (A) this;
    }

    public String getQuery(){
            return this.query;
    }

    public A withQuery(String query){
            this.query=query; return (A) this;
    }

    public A addToResults(SearchResult... items){
            for (SearchResult item : items) {SearchResultBuilder builder = new SearchResultBuilder(item);_visitables.add(builder);this.results.add(builder);} return (A)this;
    }

    public A removeFromResults(SearchResult... items){
            for (SearchResult item : items) {SearchResultBuilder builder = new SearchResultBuilder(item);_visitables.remove(builder);this.results.remove(builder);} return (A)this;
    }

    public List<SearchResult> getResults(){
            return build(results);
    }

    public A withResults(List<SearchResult> results){
            _visitables.removeAll(this.results);
            this.results.clear();
            if (results != null) {for (SearchResult item : results){this.addToResults(item);}} return (A) this;
    }

    public A withResults(SearchResult... results){
            this.results.clear(); if (results != null) {for (SearchResult item :results){ this.addToResults(item);}} return (A) this;
    }

    public SearchResultsFluent.ResultsNested<A> addNewResult(){
            return new ResultsNestedImpl();
    }

    public SearchResultsFluent.ResultsNested<A> addNewResultLike(SearchResult item){
            return new ResultsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SearchResultsFluentImpl that = (SearchResultsFluentImpl) o;
            if (numResults != null ? !numResults.equals(that.numResults) :that.numResults != null) return false;
            if (query != null ? !query.equals(that.query) :that.query != null) return false;
            if (results != null ? !results.equals(that.results) :that.results != null) return false;
            return true;
    }


    public class ResultsNestedImpl<N> extends SearchResultFluentImpl<SearchResultsFluent.ResultsNested<N>> implements SearchResultsFluent.ResultsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final SearchResultBuilder builder;
    
            ResultsNestedImpl(SearchResult item){
                    this.builder = new SearchResultBuilder(this, item);
            }
            ResultsNestedImpl(){
                    this.builder = new SearchResultBuilder(this);
            }
    
    public N and(){
            return (N) SearchResultsFluentImpl.this.addToResults(builder.build());
    }
    public N endResult(){
            return and();
    }

}


}
