package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class RestartPolicyBuilder extends RestartPolicyFluentImpl<RestartPolicyBuilder> implements VisitableBuilder<RestartPolicy,RestartPolicyBuilder>{

    RestartPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public RestartPolicyBuilder(){
            this(true);
    }
    public RestartPolicyBuilder(Boolean validationEnabled){
            this(new RestartPolicy(), validationEnabled);
    }
    public RestartPolicyBuilder(RestartPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public RestartPolicyBuilder(RestartPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RestartPolicy(), validationEnabled);
    }
    public RestartPolicyBuilder(RestartPolicyFluent<?> fluent,RestartPolicy instance){
            this(fluent, instance, true);
    }
    public RestartPolicyBuilder(RestartPolicyFluent<?> fluent,RestartPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaximumRetryCount(instance.getMaximumRetryCount()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public RestartPolicyBuilder(RestartPolicy instance){
            this(instance,true);
    }
    public RestartPolicyBuilder(RestartPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaximumRetryCount(instance.getMaximumRetryCount()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableRestartPolicy build(){
            EditableRestartPolicy buildable = new EditableRestartPolicy(fluent.getMaximumRetryCount(),fluent.getName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RestartPolicyBuilder that = (RestartPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
