package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class PortBindingBuilder extends PortBindingFluentImpl<PortBindingBuilder> implements VisitableBuilder<PortBinding,PortBindingBuilder>{

    PortBindingFluent<?> fluent;
    Boolean validationEnabled;

    public PortBindingBuilder(){
            this(true);
    }
    public PortBindingBuilder(Boolean validationEnabled){
            this(new PortBinding(), validationEnabled);
    }
    public PortBindingBuilder(PortBindingFluent<?> fluent){
            this(fluent, true);
    }
    public PortBindingBuilder(PortBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PortBinding(), validationEnabled);
    }
    public PortBindingBuilder(PortBindingFluent<?> fluent,PortBinding instance){
            this(fluent, instance, true);
    }
    public PortBindingBuilder(PortBindingFluent<?> fluent,PortBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHostIp(instance.getHostIp()); 
            fluent.withHostPort(instance.getHostPort()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortBindingBuilder(PortBinding instance){
            this(instance,true);
    }
    public PortBindingBuilder(PortBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHostIp(instance.getHostIp()); 
            this.withHostPort(instance.getHostPort()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditablePortBinding build(){
            EditablePortBinding buildable = new EditablePortBinding(fluent.getHostIp(),fluent.getHostPort());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PortBindingBuilder that = (PortBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
