package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.docker.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class NetworkSettingsFluentImpl<A extends NetworkSettingsFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements NetworkSettingsFluent<A>{

    private VisitableBuilder<? extends DefaultNetworkSettings,?> DefaultNetworkSettings;
    private VisitableBuilder<? extends NetworkSettingsBase,?> NetworkSettingsBase;
    private Map<String,EndpointSettings> Networks = new LinkedHashMap<String,EndpointSettings>();

    public NetworkSettingsFluentImpl(){
    }
    public NetworkSettingsFluentImpl(NetworkSettings instance){
            this.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); 
            this.withNetworkSettingsBase(instance.getNetworkSettingsBase()); 
            this.withNetworks(instance.getNetworks()); 
    }

    public DefaultNetworkSettings getDefaultNetworkSettings(){
            return this.DefaultNetworkSettings!=null?this.DefaultNetworkSettings.build():null;
    }

    public A withDefaultNetworkSettings(DefaultNetworkSettings DefaultNetworkSettings){
            _visitables.remove(this.DefaultNetworkSettings);
            if (DefaultNetworkSettings!=null){ this.DefaultNetworkSettings= new DefaultNetworkSettingsBuilder(DefaultNetworkSettings); _visitables.add(this.DefaultNetworkSettings);} return (A) this;
    }

    public NetworkSettingsFluent.DefaultNetworkSettingsNested<A> withNewDefaultNetworkSettings(){
            return new DefaultNetworkSettingsNestedImpl();
    }

    public NetworkSettingsFluent.DefaultNetworkSettingsNested<A> withNewDefaultNetworkSettingsLike(DefaultNetworkSettings item){
            return new DefaultNetworkSettingsNestedImpl(item);
    }

    public NetworkSettingsFluent.DefaultNetworkSettingsNested<A> editDefaultNetworkSettings(){
            return withNewDefaultNetworkSettingsLike(getDefaultNetworkSettings());
    }

    public NetworkSettingsFluent.DefaultNetworkSettingsNested<A> editOrNewDefaultNetworkSettings(){
            return withNewDefaultNetworkSettingsLike(getDefaultNetworkSettings() != null ? getDefaultNetworkSettings(): new DefaultNetworkSettingsBuilder().build());
    }

    public NetworkSettingsFluent.DefaultNetworkSettingsNested<A> editOrNewDefaultNetworkSettingsLike(DefaultNetworkSettings item){
            return withNewDefaultNetworkSettingsLike(getDefaultNetworkSettings() != null ? getDefaultNetworkSettings(): item);
    }

    public NetworkSettingsBase getNetworkSettingsBase(){
            return this.NetworkSettingsBase!=null?this.NetworkSettingsBase.build():null;
    }

    public A withNetworkSettingsBase(NetworkSettingsBase NetworkSettingsBase){
            _visitables.remove(this.NetworkSettingsBase);
            if (NetworkSettingsBase!=null){ this.NetworkSettingsBase= new NetworkSettingsBaseBuilder(NetworkSettingsBase); _visitables.add(this.NetworkSettingsBase);} return (A) this;
    }

    public NetworkSettingsFluent.NetworkSettingsBaseNested<A> withNewNetworkSettingsBase(){
            return new NetworkSettingsBaseNestedImpl();
    }

    public NetworkSettingsFluent.NetworkSettingsBaseNested<A> withNewNetworkSettingsBaseLike(NetworkSettingsBase item){
            return new NetworkSettingsBaseNestedImpl(item);
    }

    public NetworkSettingsFluent.NetworkSettingsBaseNested<A> editNetworkSettingsBase(){
            return withNewNetworkSettingsBaseLike(getNetworkSettingsBase());
    }

    public NetworkSettingsFluent.NetworkSettingsBaseNested<A> editOrNewNetworkSettingsBase(){
            return withNewNetworkSettingsBaseLike(getNetworkSettingsBase() != null ? getNetworkSettingsBase(): new NetworkSettingsBaseBuilder().build());
    }

    public NetworkSettingsFluent.NetworkSettingsBaseNested<A> editOrNewNetworkSettingsBaseLike(NetworkSettingsBase item){
            return withNewNetworkSettingsBaseLike(getNetworkSettingsBase() != null ? getNetworkSettingsBase(): item);
    }

    public A addToNetworks(String key,EndpointSettings value){
            if(key != null && value != null) {this.Networks.put(key, value);} return (A)this;
    }

    public A addToNetworks(Map<String,EndpointSettings> map){
            if(map != null) { this.Networks.putAll(map);} return (A)this;
    }

    public A removeFromNetworks(String key){
            if(key != null) {this.Networks.remove(key);} return (A)this;
    }

    public A removeFromNetworks(Map<String,EndpointSettings> map){
            if(map != null) { for(Object key : map.keySet()) {this.Networks.remove(key);}} return (A)this;
    }

    public Map<String,EndpointSettings> getNetworks(){
            return this.Networks;
    }

    public A withNetworks(Map<String,EndpointSettings> Networks){
            this.Networks.clear();
            if (Networks != null) {this.Networks.putAll(Networks);} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkSettingsFluentImpl that = (NetworkSettingsFluentImpl) o;
            if (DefaultNetworkSettings != null ? !DefaultNetworkSettings.equals(that.DefaultNetworkSettings) :that.DefaultNetworkSettings != null) return false;
            if (NetworkSettingsBase != null ? !NetworkSettingsBase.equals(that.NetworkSettingsBase) :that.NetworkSettingsBase != null) return false;
            if (Networks != null ? !Networks.equals(that.Networks) :that.Networks != null) return false;
            return true;
    }


    public class DefaultNetworkSettingsNestedImpl<N> extends DefaultNetworkSettingsFluentImpl<NetworkSettingsFluent.DefaultNetworkSettingsNested<N>> implements NetworkSettingsFluent.DefaultNetworkSettingsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final DefaultNetworkSettingsBuilder builder;
    
            DefaultNetworkSettingsNestedImpl(DefaultNetworkSettings item){
                    this.builder = new DefaultNetworkSettingsBuilder(this, item);
            }
            DefaultNetworkSettingsNestedImpl(){
                    this.builder = new DefaultNetworkSettingsBuilder(this);
            }
    
    public N and(){
            return (N) NetworkSettingsFluentImpl.this.withDefaultNetworkSettings(builder.build());
    }
    public N endDefaultNetworkSettings(){
            return and();
    }

}
    public class NetworkSettingsBaseNestedImpl<N> extends NetworkSettingsBaseFluentImpl<NetworkSettingsFluent.NetworkSettingsBaseNested<N>> implements NetworkSettingsFluent.NetworkSettingsBaseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkSettingsBaseBuilder builder;
    
            NetworkSettingsBaseNestedImpl(NetworkSettingsBase item){
                    this.builder = new NetworkSettingsBaseBuilder(this, item);
            }
            NetworkSettingsBaseNestedImpl(){
                    this.builder = new NetworkSettingsBaseBuilder(this);
            }
    
    public N and(){
            return (N) NetworkSettingsFluentImpl.this.withNetworkSettingsBase(builder.build());
    }
    public N endNetworkSettingsBase(){
            return and();
    }

}


}
