package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class NetworkSettingsBuilder extends NetworkSettingsFluentImpl<NetworkSettingsBuilder> implements VisitableBuilder<NetworkSettings,NetworkSettingsBuilder>{

    NetworkSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSettingsBuilder(){
            this(true);
    }
    public NetworkSettingsBuilder(Boolean validationEnabled){
            this(new NetworkSettings(), validationEnabled);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkSettings(), validationEnabled);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent,NetworkSettings instance){
            this(fluent, instance, true);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent,NetworkSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); 
            fluent.withNetworkSettingsBase(instance.getNetworkSettingsBase()); 
            fluent.withNetworks(instance.getNetworks()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkSettingsBuilder(NetworkSettings instance){
            this(instance,true);
    }
    public NetworkSettingsBuilder(NetworkSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); 
            this.withNetworkSettingsBase(instance.getNetworkSettingsBase()); 
            this.withNetworks(instance.getNetworks()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkSettings build(){
            EditableNetworkSettings buildable = new EditableNetworkSettings(fluent.getDefaultNetworkSettings(),fluent.getNetworkSettingsBase(),fluent.getNetworks());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkSettingsBuilder that = (NetworkSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
