package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class NetworkSettingsBaseFluentImpl<A extends NetworkSettingsBaseFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements NetworkSettingsBaseFluent<A>{

    private String Bridge;
    private Boolean HairpinMode;
    private String LinkLocalIPv6Address;
    private Integer LinkLocalIPv6PrefixLen;
    private Map<String,ArrayList<PortBinding>> Ports = new LinkedHashMap<String,ArrayList<PortBinding>>();
    private String SandboxID;
    private String SandboxKey;
    private List<VisitableBuilder<? extends Address,?>> SecondaryIPAddresses =  new ArrayList<VisitableBuilder<? extends Address,?>>();
    private List<VisitableBuilder<? extends Address,?>> SecondaryIPv6Addresses =  new ArrayList<VisitableBuilder<? extends Address,?>>();

    public NetworkSettingsBaseFluentImpl(){
    }
    public NetworkSettingsBaseFluentImpl(NetworkSettingsBase instance){
            this.withBridge(instance.getBridge()); 
            this.withHairpinMode(instance.getHairpinMode()); 
            this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address()); 
            this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen()); 
            this.withPorts(instance.getPorts()); 
            this.withSandboxID(instance.getSandboxID()); 
            this.withSandboxKey(instance.getSandboxKey()); 
            this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses()); 
            this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses()); 
    }

    public String getBridge(){
            return this.Bridge;
    }

    public A withBridge(String Bridge){
            this.Bridge=Bridge; return (A) this;
    }

    public Boolean isHairpinMode(){
            return this.HairpinMode;
    }

    public A withHairpinMode(Boolean HairpinMode){
            this.HairpinMode=HairpinMode; return (A) this;
    }

    public String getLinkLocalIPv6Address(){
            return this.LinkLocalIPv6Address;
    }

    public A withLinkLocalIPv6Address(String LinkLocalIPv6Address){
            this.LinkLocalIPv6Address=LinkLocalIPv6Address; return (A) this;
    }

    public Integer getLinkLocalIPv6PrefixLen(){
            return this.LinkLocalIPv6PrefixLen;
    }

    public A withLinkLocalIPv6PrefixLen(Integer LinkLocalIPv6PrefixLen){
            this.LinkLocalIPv6PrefixLen=LinkLocalIPv6PrefixLen; return (A) this;
    }

    public A addToPorts(String key,ArrayList<PortBinding> value){
            if(key != null && value != null) {this.Ports.put(key, value);} return (A)this;
    }

    public A addToPorts(Map<String,ArrayList<PortBinding>> map){
            if(map != null) { this.Ports.putAll(map);} return (A)this;
    }

    public A removeFromPorts(String key){
            if(key != null) {this.Ports.remove(key);} return (A)this;
    }

    public A removeFromPorts(Map<String,ArrayList<PortBinding>> map){
            if(map != null) { for(Object key : map.keySet()) {this.Ports.remove(key);}} return (A)this;
    }

    public Map<String,ArrayList<PortBinding>> getPorts(){
            return this.Ports;
    }

    public A withPorts(Map<String,ArrayList<PortBinding>> Ports){
            this.Ports.clear();
            if (Ports != null) {this.Ports.putAll(Ports);} return (A) this;
    }

    public String getSandboxID(){
            return this.SandboxID;
    }

    public A withSandboxID(String SandboxID){
            this.SandboxID=SandboxID; return (A) this;
    }

    public String getSandboxKey(){
            return this.SandboxKey;
    }

    public A withSandboxKey(String SandboxKey){
            this.SandboxKey=SandboxKey; return (A) this;
    }

    public A addToSecondaryIPAddresses(Address... items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.add(builder);this.SecondaryIPAddresses.add(builder);} return (A)this;
    }

    public A removeFromSecondaryIPAddresses(Address... items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.remove(builder);this.SecondaryIPAddresses.remove(builder);} return (A)this;
    }

    public List<Address> getSecondaryIPAddresses(){
            return build(SecondaryIPAddresses);
    }

    public A withSecondaryIPAddresses(List<Address> SecondaryIPAddresses){
            _visitables.removeAll(this.SecondaryIPAddresses);
            this.SecondaryIPAddresses.clear();
            if (SecondaryIPAddresses != null) {for (Address item : SecondaryIPAddresses){this.addToSecondaryIPAddresses(item);}} return (A) this;
    }

    public A withSecondaryIPAddresses(Address... SecondaryIPAddresses){
            this.SecondaryIPAddresses.clear(); if (SecondaryIPAddresses != null) {for (Address item :SecondaryIPAddresses){ this.addToSecondaryIPAddresses(item);}} return (A) this;
    }

    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddress(){
            return new SecondaryIPAddressesNestedImpl();
    }

    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddressLike(Address item){
            return new SecondaryIPAddressesNestedImpl(item);
    }

    public A addNewSecondaryIPAddress(String Addr,Integer PrefixLen){
            return (A)addToSecondaryIPAddresses(new Address(Addr, PrefixLen));
    }

    public A addToSecondaryIPv6Addresses(Address... items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.add(builder);this.SecondaryIPv6Addresses.add(builder);} return (A)this;
    }

    public A removeFromSecondaryIPv6Addresses(Address... items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.remove(builder);this.SecondaryIPv6Addresses.remove(builder);} return (A)this;
    }

    public List<Address> getSecondaryIPv6Addresses(){
            return build(SecondaryIPv6Addresses);
    }

    public A withSecondaryIPv6Addresses(List<Address> SecondaryIPv6Addresses){
            _visitables.removeAll(this.SecondaryIPv6Addresses);
            this.SecondaryIPv6Addresses.clear();
            if (SecondaryIPv6Addresses != null) {for (Address item : SecondaryIPv6Addresses){this.addToSecondaryIPv6Addresses(item);}} return (A) this;
    }

    public A withSecondaryIPv6Addresses(Address... SecondaryIPv6Addresses){
            this.SecondaryIPv6Addresses.clear(); if (SecondaryIPv6Addresses != null) {for (Address item :SecondaryIPv6Addresses){ this.addToSecondaryIPv6Addresses(item);}} return (A) this;
    }

    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6Address(){
            return new SecondaryIPv6AddressesNestedImpl();
    }

    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6AddressLike(Address item){
            return new SecondaryIPv6AddressesNestedImpl(item);
    }

    public A addNewSecondaryIPv6Address(String Addr,Integer PrefixLen){
            return (A)addToSecondaryIPv6Addresses(new Address(Addr, PrefixLen));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkSettingsBaseFluentImpl that = (NetworkSettingsBaseFluentImpl) o;
            if (Bridge != null ? !Bridge.equals(that.Bridge) :that.Bridge != null) return false;
            if (HairpinMode != null ? !HairpinMode.equals(that.HairpinMode) :that.HairpinMode != null) return false;
            if (LinkLocalIPv6Address != null ? !LinkLocalIPv6Address.equals(that.LinkLocalIPv6Address) :that.LinkLocalIPv6Address != null) return false;
            if (LinkLocalIPv6PrefixLen != null ? !LinkLocalIPv6PrefixLen.equals(that.LinkLocalIPv6PrefixLen) :that.LinkLocalIPv6PrefixLen != null) return false;
            if (Ports != null ? !Ports.equals(that.Ports) :that.Ports != null) return false;
            if (SandboxID != null ? !SandboxID.equals(that.SandboxID) :that.SandboxID != null) return false;
            if (SandboxKey != null ? !SandboxKey.equals(that.SandboxKey) :that.SandboxKey != null) return false;
            if (SecondaryIPAddresses != null ? !SecondaryIPAddresses.equals(that.SecondaryIPAddresses) :that.SecondaryIPAddresses != null) return false;
            if (SecondaryIPv6Addresses != null ? !SecondaryIPv6Addresses.equals(that.SecondaryIPv6Addresses) :that.SecondaryIPv6Addresses != null) return false;
            return true;
    }


    public class SecondaryIPAddressesNestedImpl<N> extends AddressFluentImpl<NetworkSettingsBaseFluent.SecondaryIPAddressesNested<N>> implements NetworkSettingsBaseFluent.SecondaryIPAddressesNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final AddressBuilder builder;
    
            SecondaryIPAddressesNestedImpl(Address item){
                    this.builder = new AddressBuilder(this, item);
            }
            SecondaryIPAddressesNestedImpl(){
                    this.builder = new AddressBuilder(this);
            }
    
    public N and(){
            return (N) NetworkSettingsBaseFluentImpl.this.addToSecondaryIPAddresses(builder.build());
    }
    public N endSecondaryIPAddress(){
            return and();
    }

}
    public class SecondaryIPv6AddressesNestedImpl<N> extends AddressFluentImpl<NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<N>> implements NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final AddressBuilder builder;
    
            SecondaryIPv6AddressesNestedImpl(Address item){
                    this.builder = new AddressBuilder(this, item);
            }
            SecondaryIPv6AddressesNestedImpl(){
                    this.builder = new AddressBuilder(this);
            }
    
    public N and(){
            return (N) NetworkSettingsBaseFluentImpl.this.addToSecondaryIPv6Addresses(builder.build());
    }
    public N endSecondaryIPv6Address(){
            return and();
    }

}


}
