package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.docker.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface NetworkSettingsBaseFluent<A extends NetworkSettingsBaseFluent<A>> extends Fluent<A>{


    public String getBridge();
    public A withBridge(String Bridge);
    public Boolean isHairpinMode();
    public A withHairpinMode(Boolean HairpinMode);
    public String getLinkLocalIPv6Address();
    public A withLinkLocalIPv6Address(String LinkLocalIPv6Address);
    public Integer getLinkLocalIPv6PrefixLen();
    public A withLinkLocalIPv6PrefixLen(Integer LinkLocalIPv6PrefixLen);
    public A addToPorts(String key,ArrayList<PortBinding> value);
    public A addToPorts(Map<String,ArrayList<PortBinding>> map);
    public A removeFromPorts(String key);
    public A removeFromPorts(Map<String,ArrayList<PortBinding>> map);
    public Map<String,ArrayList<PortBinding>> getPorts();
    public A withPorts(Map<String,ArrayList<PortBinding>> Ports);
    public String getSandboxID();
    public A withSandboxID(String SandboxID);
    public String getSandboxKey();
    public A withSandboxKey(String SandboxKey);
    public A addToSecondaryIPAddresses(Address... items);
    public A removeFromSecondaryIPAddresses(Address... items);
    public List<Address> getSecondaryIPAddresses();
    public A withSecondaryIPAddresses(List<Address> SecondaryIPAddresses);
    public A withSecondaryIPAddresses(Address... SecondaryIPAddresses);
    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddress();
    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddressLike(Address item);
    public A addNewSecondaryIPAddress(String Addr,Integer PrefixLen);
    public A addToSecondaryIPv6Addresses(Address... items);
    public A removeFromSecondaryIPv6Addresses(Address... items);
    public List<Address> getSecondaryIPv6Addresses();
    public A withSecondaryIPv6Addresses(List<Address> SecondaryIPv6Addresses);
    public A withSecondaryIPv6Addresses(Address... SecondaryIPv6Addresses);
    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6Address();
    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6AddressLike(Address item);
    public A addNewSecondaryIPv6Address(String Addr,Integer PrefixLen);

    public interface SecondaryIPAddressesNested<N> extends io.fabric8.docker.api.builder.Nested<N>,AddressFluent<NetworkSettingsBaseFluent.SecondaryIPAddressesNested<N>>{

        
    public N and();    public N endSecondaryIPAddress();
}
    public interface SecondaryIPv6AddressesNested<N> extends io.fabric8.docker.api.builder.Nested<N>,AddressFluent<NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<N>>{

        
    public N and();    public N endSecondaryIPv6Address();
}


}
