package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class NetworkSettingsBaseBuilder extends NetworkSettingsBaseFluentImpl<NetworkSettingsBaseBuilder> implements VisitableBuilder<NetworkSettingsBase,NetworkSettingsBaseBuilder>{

    NetworkSettingsBaseFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSettingsBaseBuilder(){
            this(true);
    }
    public NetworkSettingsBaseBuilder(Boolean validationEnabled){
            this(new NetworkSettingsBase(), validationEnabled);
    }
    public NetworkSettingsBaseBuilder(NetworkSettingsBaseFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkSettingsBaseBuilder(NetworkSettingsBaseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkSettingsBase(), validationEnabled);
    }
    public NetworkSettingsBaseBuilder(NetworkSettingsBaseFluent<?> fluent,NetworkSettingsBase instance){
            this(fluent, instance, true);
    }
    public NetworkSettingsBaseBuilder(NetworkSettingsBaseFluent<?> fluent,NetworkSettingsBase instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBridge(instance.getBridge()); 
            fluent.withHairpinMode(instance.getHairpinMode()); 
            fluent.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address()); 
            fluent.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen()); 
            fluent.withPorts(instance.getPorts()); 
            fluent.withSandboxID(instance.getSandboxID()); 
            fluent.withSandboxKey(instance.getSandboxKey()); 
            fluent.withSecondaryIPAddresses(instance.getSecondaryIPAddresses()); 
            fluent.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkSettingsBaseBuilder(NetworkSettingsBase instance){
            this(instance,true);
    }
    public NetworkSettingsBaseBuilder(NetworkSettingsBase instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBridge(instance.getBridge()); 
            this.withHairpinMode(instance.getHairpinMode()); 
            this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address()); 
            this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen()); 
            this.withPorts(instance.getPorts()); 
            this.withSandboxID(instance.getSandboxID()); 
            this.withSandboxKey(instance.getSandboxKey()); 
            this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses()); 
            this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkSettingsBase build(){
            EditableNetworkSettingsBase buildable = new EditableNetworkSettingsBase(fluent.getBridge(),fluent.isHairpinMode(),fluent.getLinkLocalIPv6Address(),fluent.getLinkLocalIPv6PrefixLen(),fluent.getPorts(),fluent.getSandboxID(),fluent.getSandboxKey(),fluent.getSecondaryIPAddresses(),fluent.getSecondaryIPv6Addresses());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkSettingsBaseBuilder that = (NetworkSettingsBaseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
