package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class NetworkResourceBuilder extends NetworkResourceFluentImpl<NetworkResourceBuilder> implements VisitableBuilder<NetworkResource,NetworkResourceBuilder>{

    NetworkResourceFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkResourceBuilder(){
            this(true);
    }
    public NetworkResourceBuilder(Boolean validationEnabled){
            this(new NetworkResource(), validationEnabled);
    }
    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkResource(), validationEnabled);
    }
    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent,NetworkResource instance){
            this(fluent, instance, true);
    }
    public NetworkResourceBuilder(NetworkResourceFluent<?> fluent,NetworkResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContainers(instance.getContainers()); 
            fluent.withDriver(instance.getDriver()); 
            fluent.withIPAM(instance.getIPAM()); 
            fluent.withId(instance.getId()); 
            fluent.withName(instance.getName()); 
            fluent.withOptions(instance.getOptions()); 
            fluent.withScope(instance.getScope()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkResourceBuilder(NetworkResource instance){
            this(instance,true);
    }
    public NetworkResourceBuilder(NetworkResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContainers(instance.getContainers()); 
            this.withDriver(instance.getDriver()); 
            this.withIPAM(instance.getIPAM()); 
            this.withId(instance.getId()); 
            this.withName(instance.getName()); 
            this.withOptions(instance.getOptions()); 
            this.withScope(instance.getScope()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkResource build(){
            EditableNetworkResource buildable = new EditableNetworkResource(fluent.getContainers(),fluent.getDriver(),fluent.getIPAM(),fluent.getId(),fluent.getName(),fluent.getOptions(),fluent.getScope());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkResourceBuilder that = (NetworkResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
