package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class NetworkDisconnectBuilder extends NetworkDisconnectFluentImpl<NetworkDisconnectBuilder> implements VisitableBuilder<NetworkDisconnect,NetworkDisconnectBuilder>{

    NetworkDisconnectFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkDisconnectBuilder(){
            this(true);
    }
    public NetworkDisconnectBuilder(Boolean validationEnabled){
            this(new NetworkDisconnect(), validationEnabled);
    }
    public NetworkDisconnectBuilder(NetworkDisconnectFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkDisconnectBuilder(NetworkDisconnectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkDisconnect(), validationEnabled);
    }
    public NetworkDisconnectBuilder(NetworkDisconnectFluent<?> fluent,NetworkDisconnect instance){
            this(fluent, instance, true);
    }
    public NetworkDisconnectBuilder(NetworkDisconnectFluent<?> fluent,NetworkDisconnect instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContainer(instance.getContainer()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkDisconnectBuilder(NetworkDisconnect instance){
            this(instance,true);
    }
    public NetworkDisconnectBuilder(NetworkDisconnect instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContainer(instance.getContainer()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkDisconnect build(){
            EditableNetworkDisconnect buildable = new EditableNetworkDisconnect(fluent.getContainer());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkDisconnectBuilder that = (NetworkDisconnectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
