package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class NetworkCreateResponseBuilder extends NetworkCreateResponseFluentImpl<NetworkCreateResponseBuilder> implements VisitableBuilder<NetworkCreateResponse,NetworkCreateResponseBuilder>{

    NetworkCreateResponseFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkCreateResponseBuilder(){
            this(true);
    }
    public NetworkCreateResponseBuilder(Boolean validationEnabled){
            this(new NetworkCreateResponse(), validationEnabled);
    }
    public NetworkCreateResponseBuilder(NetworkCreateResponseFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkCreateResponseBuilder(NetworkCreateResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkCreateResponse(), validationEnabled);
    }
    public NetworkCreateResponseBuilder(NetworkCreateResponseFluent<?> fluent,NetworkCreateResponse instance){
            this(fluent, instance, true);
    }
    public NetworkCreateResponseBuilder(NetworkCreateResponseFluent<?> fluent,NetworkCreateResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withId(instance.getId()); 
            fluent.withWarning(instance.getWarning()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkCreateResponseBuilder(NetworkCreateResponse instance){
            this(instance,true);
    }
    public NetworkCreateResponseBuilder(NetworkCreateResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withId(instance.getId()); 
            this.withWarning(instance.getWarning()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkCreateResponse build(){
            EditableNetworkCreateResponse buildable = new EditableNetworkCreateResponse(fluent.getId(),fluent.getWarning());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkCreateResponseBuilder that = (NetworkCreateResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
