package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.docker.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class NetworkCreateFluentImpl<A extends NetworkCreateFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements NetworkCreateFluent<A>{

    private Boolean CheckDuplicate;
    private String Driver;
    private VisitableBuilder<? extends IPAM,?> IPAM;
    private String Name;
    private Map<String,String> Options = new LinkedHashMap<String,String>();

    public NetworkCreateFluentImpl(){
    }
    public NetworkCreateFluentImpl(NetworkCreate instance){
            this.withCheckDuplicate(instance.getCheckDuplicate()); 
            this.withDriver(instance.getDriver()); 
            this.withIPAM(instance.getIPAM()); 
            this.withName(instance.getName()); 
            this.withOptions(instance.getOptions()); 
    }

    public Boolean isCheckDuplicate(){
            return this.CheckDuplicate;
    }

    public A withCheckDuplicate(Boolean CheckDuplicate){
            this.CheckDuplicate=CheckDuplicate; return (A) this;
    }

    public String getDriver(){
            return this.Driver;
    }

    public A withDriver(String Driver){
            this.Driver=Driver; return (A) this;
    }

    public IPAM getIPAM(){
            return this.IPAM!=null?this.IPAM.build():null;
    }

    public A withIPAM(IPAM IPAM){
            _visitables.remove(this.IPAM);
            if (IPAM!=null){ this.IPAM= new IPAMBuilder(IPAM); _visitables.add(this.IPAM);} return (A) this;
    }

    public NetworkCreateFluent.IPAMNested<A> withNewIPAM(){
            return new IPAMNestedImpl();
    }

    public NetworkCreateFluent.IPAMNested<A> withNewIPAMLike(IPAM item){
            return new IPAMNestedImpl(item);
    }

    public NetworkCreateFluent.IPAMNested<A> editIPAM(){
            return withNewIPAMLike(getIPAM());
    }

    public NetworkCreateFluent.IPAMNested<A> editOrNewIPAM(){
            return withNewIPAMLike(getIPAM() != null ? getIPAM(): new IPAMBuilder().build());
    }

    public NetworkCreateFluent.IPAMNested<A> editOrNewIPAMLike(IPAM item){
            return withNewIPAMLike(getIPAM() != null ? getIPAM(): item);
    }

    public String getName(){
            return this.Name;
    }

    public A withName(String Name){
            this.Name=Name; return (A) this;
    }

    public A addToOptions(String key,String value){
            if(key != null && value != null) {this.Options.put(key, value);} return (A)this;
    }

    public A addToOptions(Map<String,String> map){
            if(map != null) { this.Options.putAll(map);} return (A)this;
    }

    public A removeFromOptions(String key){
            if(key != null) {this.Options.remove(key);} return (A)this;
    }

    public A removeFromOptions(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.Options.remove(key);}} return (A)this;
    }

    public Map<String,String> getOptions(){
            return this.Options;
    }

    public A withOptions(Map<String,String> Options){
            this.Options.clear();
            if (Options != null) {this.Options.putAll(Options);} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkCreateFluentImpl that = (NetworkCreateFluentImpl) o;
            if (CheckDuplicate != null ? !CheckDuplicate.equals(that.CheckDuplicate) :that.CheckDuplicate != null) return false;
            if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
            if (IPAM != null ? !IPAM.equals(that.IPAM) :that.IPAM != null) return false;
            if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
            if (Options != null ? !Options.equals(that.Options) :that.Options != null) return false;
            return true;
    }


    public class IPAMNestedImpl<N> extends IPAMFluentImpl<NetworkCreateFluent.IPAMNested<N>> implements NetworkCreateFluent.IPAMNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final IPAMBuilder builder;
    
            IPAMNestedImpl(IPAM item){
                    this.builder = new IPAMBuilder(this, item);
            }
            IPAMNestedImpl(){
                    this.builder = new IPAMBuilder(this);
            }
    
    public N and(){
            return (N) NetworkCreateFluentImpl.this.withIPAM(builder.build());
    }
    public N endIPAM(){
            return and();
    }

}


}
