package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class NetIPNetBuilder extends NetIPNetFluentImpl<NetIPNetBuilder> implements VisitableBuilder<NetIPNet,NetIPNetBuilder>{

    NetIPNetFluent<?> fluent;
    Boolean validationEnabled;

    public NetIPNetBuilder(){
            this(true);
    }
    public NetIPNetBuilder(Boolean validationEnabled){
            this(new NetIPNet(), validationEnabled);
    }
    public NetIPNetBuilder(NetIPNetFluent<?> fluent){
            this(fluent, true);
    }
    public NetIPNetBuilder(NetIPNetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetIPNet(), validationEnabled);
    }
    public NetIPNetBuilder(NetIPNetFluent<?> fluent,NetIPNet instance){
            this(fluent, instance, true);
    }
    public NetIPNetBuilder(NetIPNetFluent<?> fluent,NetIPNet instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIp(instance.getIp()); 
            fluent.withMask(instance.getMask()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetIPNetBuilder(NetIPNet instance){
            this(instance,true);
    }
    public NetIPNetBuilder(NetIPNet instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIp(instance.getIp()); 
            this.withMask(instance.getMask()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetIPNet build(){
            EditableNetIPNet buildable = new EditableNetIPNet(fluent.getIp(),fluent.getMask());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetIPNetBuilder that = (NetIPNetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
