package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import java.util.LinkedHashMap;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public class MemoryStatsFluentImpl<A extends MemoryStatsFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements MemoryStatsFluent<A>{

    private Long failcnt;
    private Long limit;
    private Long maxUsage;
    private Map<String,Long> stats = new LinkedHashMap<String,Long>();
    private Long usage;

    public MemoryStatsFluentImpl(){
    }
    public MemoryStatsFluentImpl(MemoryStats instance){
            this.withFailcnt(instance.getFailcnt()); 
            this.withLimit(instance.getLimit()); 
            this.withMaxUsage(instance.getMaxUsage()); 
            this.withStats(instance.getStats()); 
            this.withUsage(instance.getUsage()); 
    }

    public Long getFailcnt(){
            return this.failcnt;
    }

    public A withFailcnt(Long failcnt){
            this.failcnt=failcnt; return (A) this;
    }

    public Long getLimit(){
            return this.limit;
    }

    public A withLimit(Long limit){
            this.limit=limit; return (A) this;
    }

    public Long getMaxUsage(){
            return this.maxUsage;
    }

    public A withMaxUsage(Long maxUsage){
            this.maxUsage=maxUsage; return (A) this;
    }

    public A addToStats(String key,Long value){
            if(key != null && value != null) {this.stats.put(key, value);} return (A)this;
    }

    public A addToStats(Map<String,Long> map){
            if(map != null) { this.stats.putAll(map);} return (A)this;
    }

    public A removeFromStats(String key){
            if(key != null) {this.stats.remove(key);} return (A)this;
    }

    public A removeFromStats(Map<String,Long> map){
            if(map != null) { for(Object key : map.keySet()) {this.stats.remove(key);}} return (A)this;
    }

    public Map<String,Long> getStats(){
            return this.stats;
    }

    public A withStats(Map<String,Long> stats){
            this.stats.clear();
            if (stats != null) {this.stats.putAll(stats);} return (A) this;
    }

    public Long getUsage(){
            return this.usage;
    }

    public A withUsage(Long usage){
            this.usage=usage; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MemoryStatsFluentImpl that = (MemoryStatsFluentImpl) o;
            if (failcnt != null ? !failcnt.equals(that.failcnt) :that.failcnt != null) return false;
            if (limit != null ? !limit.equals(that.limit) :that.limit != null) return false;
            if (maxUsage != null ? !maxUsage.equals(that.maxUsage) :that.maxUsage != null) return false;
            if (stats != null ? !stats.equals(that.stats) :that.stats != null) return false;
            if (usage != null ? !usage.equals(that.usage) :that.usage != null) return false;
            return true;
    }




}
