package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class MemoryStatsBuilder extends MemoryStatsFluentImpl<MemoryStatsBuilder> implements VisitableBuilder<MemoryStats,MemoryStatsBuilder>{

    MemoryStatsFluent<?> fluent;
    Boolean validationEnabled;

    public MemoryStatsBuilder(){
            this(true);
    }
    public MemoryStatsBuilder(Boolean validationEnabled){
            this(new MemoryStats(), validationEnabled);
    }
    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent){
            this(fluent, true);
    }
    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MemoryStats(), validationEnabled);
    }
    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent,MemoryStats instance){
            this(fluent, instance, true);
    }
    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent,MemoryStats instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFailcnt(instance.getFailcnt()); 
            fluent.withLimit(instance.getLimit()); 
            fluent.withMaxUsage(instance.getMaxUsage()); 
            fluent.withStats(instance.getStats()); 
            fluent.withUsage(instance.getUsage()); 
            this.validationEnabled = validationEnabled; 
    }
    public MemoryStatsBuilder(MemoryStats instance){
            this(instance,true);
    }
    public MemoryStatsBuilder(MemoryStats instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFailcnt(instance.getFailcnt()); 
            this.withLimit(instance.getLimit()); 
            this.withMaxUsage(instance.getMaxUsage()); 
            this.withStats(instance.getStats()); 
            this.withUsage(instance.getUsage()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableMemoryStats build(){
            EditableMemoryStats buildable = new EditableMemoryStats(fluent.getFailcnt(),fluent.getLimit(),fluent.getMaxUsage(),fluent.getStats(),fluent.getUsage());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MemoryStatsBuilder that = (MemoryStatsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
