package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class KeyValuePairBuilder extends KeyValuePairFluentImpl<KeyValuePairBuilder> implements VisitableBuilder<KeyValuePair,KeyValuePairBuilder>{

    KeyValuePairFluent<?> fluent;
    Boolean validationEnabled;

    public KeyValuePairBuilder(){
            this(true);
    }
    public KeyValuePairBuilder(Boolean validationEnabled){
            this(new KeyValuePair(), validationEnabled);
    }
    public KeyValuePairBuilder(KeyValuePairFluent<?> fluent){
            this(fluent, true);
    }
    public KeyValuePairBuilder(KeyValuePairFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KeyValuePair(), validationEnabled);
    }
    public KeyValuePairBuilder(KeyValuePairFluent<?> fluent,KeyValuePair instance){
            this(fluent, instance, true);
    }
    public KeyValuePairBuilder(KeyValuePairFluent<?> fluent,KeyValuePair instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKey(instance.getKey()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public KeyValuePairBuilder(KeyValuePair instance){
            this(instance,true);
    }
    public KeyValuePairBuilder(KeyValuePair instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKey(instance.getKey()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableKeyValuePair build(){
            EditableKeyValuePair buildable = new EditableKeyValuePair(fluent.getKey(),fluent.getValue());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KeyValuePairBuilder that = (KeyValuePairBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
