package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class InfoFluentImpl<A extends InfoFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements InfoFluent<A>{

    private Boolean BridgeNfIp6tables;
    private Boolean BridgeNfIptables;
    private String ClusterAdvertise;
    private String ClusterStore;
    private Integer Containers;
    private Boolean CpuCfsPeriod;
    private Boolean CpuCfsQuota;
    private Boolean Debug;
    private String DockerRootDir;
    private String Driver;
    private List<Object> DriverStatus = new ArrayList<Object>();
    private String ExecutionDriver;
    private Boolean ExperimentalBuild;
    private String HttpProxy;
    private String HttpsProxy;
    private String ID;
    private Boolean IPv4Forwarding;
    private Integer Images;
    private String IndexServerAddress;
    private String InitPath;
    private String InitSha1;
    private String KernelVersion;
    private List<String> Labels = new ArrayList<String>();
    private String LoggingDriver;
    private Long MemTotal;
    private Boolean MemoryLimit;
    private Integer NCPU;
    private Integer NEventsListener;
    private Integer NFd;
    private Integer NGoroutines;
    private String Name;
    private String NoProxy;
    private Boolean OomKillDisable;
    private String OperatingSystem;
    private VisitableBuilder<? extends ServiceConfig,?> RegistryConfig;
    private String ServerVersion;
    private Boolean SwapLimit;
    private String SystemTime;

    public InfoFluentImpl(){
    }
    public InfoFluentImpl(Info instance){
            this.withBridgeNfIp6tables(instance.getBridgeNfIp6tables()); 
            this.withBridgeNfIptables(instance.getBridgeNfIptables()); 
            this.withClusterAdvertise(instance.getClusterAdvertise()); 
            this.withClusterStore(instance.getClusterStore()); 
            this.withContainers(instance.getContainers()); 
            this.withCpuCfsPeriod(instance.getCpuCfsPeriod()); 
            this.withCpuCfsQuota(instance.getCpuCfsQuota()); 
            this.withDebug(instance.getDebug()); 
            this.withDockerRootDir(instance.getDockerRootDir()); 
            this.withDriver(instance.getDriver()); 
            this.withDriverStatus(instance.getDriverStatus()); 
            this.withExecutionDriver(instance.getExecutionDriver()); 
            this.withExperimentalBuild(instance.getExperimentalBuild()); 
            this.withHttpProxy(instance.getHttpProxy()); 
            this.withHttpsProxy(instance.getHttpsProxy()); 
            this.withID(instance.getID()); 
            this.withIPv4Forwarding(instance.getIPv4Forwarding()); 
            this.withImages(instance.getImages()); 
            this.withIndexServerAddress(instance.getIndexServerAddress()); 
            this.withInitPath(instance.getInitPath()); 
            this.withInitSha1(instance.getInitSha1()); 
            this.withKernelVersion(instance.getKernelVersion()); 
            this.withLabels(instance.getLabels()); 
            this.withLoggingDriver(instance.getLoggingDriver()); 
            this.withMemTotal(instance.getMemTotal()); 
            this.withMemoryLimit(instance.getMemoryLimit()); 
            this.withNCPU(instance.getNCPU()); 
            this.withNEventsListener(instance.getNEventsListener()); 
            this.withNFd(instance.getNFd()); 
            this.withNGoroutines(instance.getNGoroutines()); 
            this.withName(instance.getName()); 
            this.withNoProxy(instance.getNoProxy()); 
            this.withOomKillDisable(instance.getOomKillDisable()); 
            this.withOperatingSystem(instance.getOperatingSystem()); 
            this.withRegistryConfig(instance.getRegistryConfig()); 
            this.withServerVersion(instance.getServerVersion()); 
            this.withSwapLimit(instance.getSwapLimit()); 
            this.withSystemTime(instance.getSystemTime()); 
    }

    public Boolean isBridgeNfIp6tables(){
            return this.BridgeNfIp6tables;
    }

    public A withBridgeNfIp6tables(Boolean BridgeNfIp6tables){
            this.BridgeNfIp6tables=BridgeNfIp6tables; return (A) this;
    }

    public Boolean isBridgeNfIptables(){
            return this.BridgeNfIptables;
    }

    public A withBridgeNfIptables(Boolean BridgeNfIptables){
            this.BridgeNfIptables=BridgeNfIptables; return (A) this;
    }

    public String getClusterAdvertise(){
            return this.ClusterAdvertise;
    }

    public A withClusterAdvertise(String ClusterAdvertise){
            this.ClusterAdvertise=ClusterAdvertise; return (A) this;
    }

    public String getClusterStore(){
            return this.ClusterStore;
    }

    public A withClusterStore(String ClusterStore){
            this.ClusterStore=ClusterStore; return (A) this;
    }

    public Integer getContainers(){
            return this.Containers;
    }

    public A withContainers(Integer Containers){
            this.Containers=Containers; return (A) this;
    }

    public Boolean isCpuCfsPeriod(){
            return this.CpuCfsPeriod;
    }

    public A withCpuCfsPeriod(Boolean CpuCfsPeriod){
            this.CpuCfsPeriod=CpuCfsPeriod; return (A) this;
    }

    public Boolean isCpuCfsQuota(){
            return this.CpuCfsQuota;
    }

    public A withCpuCfsQuota(Boolean CpuCfsQuota){
            this.CpuCfsQuota=CpuCfsQuota; return (A) this;
    }

    public Boolean isDebug(){
            return this.Debug;
    }

    public A withDebug(Boolean Debug){
            this.Debug=Debug; return (A) this;
    }

    public String getDockerRootDir(){
            return this.DockerRootDir;
    }

    public A withDockerRootDir(String DockerRootDir){
            this.DockerRootDir=DockerRootDir; return (A) this;
    }

    public String getDriver(){
            return this.Driver;
    }

    public A withDriver(String Driver){
            this.Driver=Driver; return (A) this;
    }

    public A addToDriverStatus(Object... items){
            for (Object item : items) {this.DriverStatus.add(item);} return (A)this;
    }

    public A removeFromDriverStatus(Object... items){
            for (Object item : items) {this.DriverStatus.remove(item);} return (A)this;
    }

    public List<Object> getDriverStatus(){
            return this.DriverStatus;
    }

    public A withDriverStatus(List<Object> DriverStatus){
            this.DriverStatus.clear();
            if (DriverStatus != null) {for (Object item : DriverStatus){this.addToDriverStatus(item);}} return (A) this;
    }

    public A withDriverStatus(Object... DriverStatus){
            this.DriverStatus.clear(); if (DriverStatus != null) {for (Object item :DriverStatus){ this.addToDriverStatus(item);}} return (A) this;
    }

    public String getExecutionDriver(){
            return this.ExecutionDriver;
    }

    public A withExecutionDriver(String ExecutionDriver){
            this.ExecutionDriver=ExecutionDriver; return (A) this;
    }

    public Boolean isExperimentalBuild(){
            return this.ExperimentalBuild;
    }

    public A withExperimentalBuild(Boolean ExperimentalBuild){
            this.ExperimentalBuild=ExperimentalBuild; return (A) this;
    }

    public String getHttpProxy(){
            return this.HttpProxy;
    }

    public A withHttpProxy(String HttpProxy){
            this.HttpProxy=HttpProxy; return (A) this;
    }

    public String getHttpsProxy(){
            return this.HttpsProxy;
    }

    public A withHttpsProxy(String HttpsProxy){
            this.HttpsProxy=HttpsProxy; return (A) this;
    }

    public String getID(){
            return this.ID;
    }

    public A withID(String ID){
            this.ID=ID; return (A) this;
    }

    public Boolean isIPv4Forwarding(){
            return this.IPv4Forwarding;
    }

    public A withIPv4Forwarding(Boolean IPv4Forwarding){
            this.IPv4Forwarding=IPv4Forwarding; return (A) this;
    }

    public Integer getImages(){
            return this.Images;
    }

    public A withImages(Integer Images){
            this.Images=Images; return (A) this;
    }

    public String getIndexServerAddress(){
            return this.IndexServerAddress;
    }

    public A withIndexServerAddress(String IndexServerAddress){
            this.IndexServerAddress=IndexServerAddress; return (A) this;
    }

    public String getInitPath(){
            return this.InitPath;
    }

    public A withInitPath(String InitPath){
            this.InitPath=InitPath; return (A) this;
    }

    public String getInitSha1(){
            return this.InitSha1;
    }

    public A withInitSha1(String InitSha1){
            this.InitSha1=InitSha1; return (A) this;
    }

    public String getKernelVersion(){
            return this.KernelVersion;
    }

    public A withKernelVersion(String KernelVersion){
            this.KernelVersion=KernelVersion; return (A) this;
    }

    public A addToLabels(String... items){
            for (String item : items) {this.Labels.add(item);} return (A)this;
    }

    public A removeFromLabels(String... items){
            for (String item : items) {this.Labels.remove(item);} return (A)this;
    }

    public List<String> getLabels(){
            return this.Labels;
    }

    public A withLabels(List<String> Labels){
            this.Labels.clear();
            if (Labels != null) {for (String item : Labels){this.addToLabels(item);}} return (A) this;
    }

    public A withLabels(String... Labels){
            this.Labels.clear(); if (Labels != null) {for (String item :Labels){ this.addToLabels(item);}} return (A) this;
    }

    public String getLoggingDriver(){
            return this.LoggingDriver;
    }

    public A withLoggingDriver(String LoggingDriver){
            this.LoggingDriver=LoggingDriver; return (A) this;
    }

    public Long getMemTotal(){
            return this.MemTotal;
    }

    public A withMemTotal(Long MemTotal){
            this.MemTotal=MemTotal; return (A) this;
    }

    public Boolean isMemoryLimit(){
            return this.MemoryLimit;
    }

    public A withMemoryLimit(Boolean MemoryLimit){
            this.MemoryLimit=MemoryLimit; return (A) this;
    }

    public Integer getNCPU(){
            return this.NCPU;
    }

    public A withNCPU(Integer NCPU){
            this.NCPU=NCPU; return (A) this;
    }

    public Integer getNEventsListener(){
            return this.NEventsListener;
    }

    public A withNEventsListener(Integer NEventsListener){
            this.NEventsListener=NEventsListener; return (A) this;
    }

    public Integer getNFd(){
            return this.NFd;
    }

    public A withNFd(Integer NFd){
            this.NFd=NFd; return (A) this;
    }

    public Integer getNGoroutines(){
            return this.NGoroutines;
    }

    public A withNGoroutines(Integer NGoroutines){
            this.NGoroutines=NGoroutines; return (A) this;
    }

    public String getName(){
            return this.Name;
    }

    public A withName(String Name){
            this.Name=Name; return (A) this;
    }

    public String getNoProxy(){
            return this.NoProxy;
    }

    public A withNoProxy(String NoProxy){
            this.NoProxy=NoProxy; return (A) this;
    }

    public Boolean isOomKillDisable(){
            return this.OomKillDisable;
    }

    public A withOomKillDisable(Boolean OomKillDisable){
            this.OomKillDisable=OomKillDisable; return (A) this;
    }

    public String getOperatingSystem(){
            return this.OperatingSystem;
    }

    public A withOperatingSystem(String OperatingSystem){
            this.OperatingSystem=OperatingSystem; return (A) this;
    }

    public ServiceConfig getRegistryConfig(){
            return this.RegistryConfig!=null?this.RegistryConfig.build():null;
    }

    public A withRegistryConfig(ServiceConfig RegistryConfig){
            _visitables.remove(this.RegistryConfig);
            if (RegistryConfig!=null){ this.RegistryConfig= new ServiceConfigBuilder(RegistryConfig); _visitables.add(this.RegistryConfig);} return (A) this;
    }

    public InfoFluent.RegistryConfigNested<A> withNewRegistryConfig(){
            return new RegistryConfigNestedImpl();
    }

    public InfoFluent.RegistryConfigNested<A> withNewRegistryConfigLike(ServiceConfig item){
            return new RegistryConfigNestedImpl(item);
    }

    public InfoFluent.RegistryConfigNested<A> editRegistryConfig(){
            return withNewRegistryConfigLike(getRegistryConfig());
    }

    public InfoFluent.RegistryConfigNested<A> editOrNewRegistryConfig(){
            return withNewRegistryConfigLike(getRegistryConfig() != null ? getRegistryConfig(): new ServiceConfigBuilder().build());
    }

    public InfoFluent.RegistryConfigNested<A> editOrNewRegistryConfigLike(ServiceConfig item){
            return withNewRegistryConfigLike(getRegistryConfig() != null ? getRegistryConfig(): item);
    }

    public String getServerVersion(){
            return this.ServerVersion;
    }

    public A withServerVersion(String ServerVersion){
            this.ServerVersion=ServerVersion; return (A) this;
    }

    public Boolean isSwapLimit(){
            return this.SwapLimit;
    }

    public A withSwapLimit(Boolean SwapLimit){
            this.SwapLimit=SwapLimit; return (A) this;
    }

    public String getSystemTime(){
            return this.SystemTime;
    }

    public A withSystemTime(String SystemTime){
            this.SystemTime=SystemTime; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InfoFluentImpl that = (InfoFluentImpl) o;
            if (BridgeNfIp6tables != null ? !BridgeNfIp6tables.equals(that.BridgeNfIp6tables) :that.BridgeNfIp6tables != null) return false;
            if (BridgeNfIptables != null ? !BridgeNfIptables.equals(that.BridgeNfIptables) :that.BridgeNfIptables != null) return false;
            if (ClusterAdvertise != null ? !ClusterAdvertise.equals(that.ClusterAdvertise) :that.ClusterAdvertise != null) return false;
            if (ClusterStore != null ? !ClusterStore.equals(that.ClusterStore) :that.ClusterStore != null) return false;
            if (Containers != null ? !Containers.equals(that.Containers) :that.Containers != null) return false;
            if (CpuCfsPeriod != null ? !CpuCfsPeriod.equals(that.CpuCfsPeriod) :that.CpuCfsPeriod != null) return false;
            if (CpuCfsQuota != null ? !CpuCfsQuota.equals(that.CpuCfsQuota) :that.CpuCfsQuota != null) return false;
            if (Debug != null ? !Debug.equals(that.Debug) :that.Debug != null) return false;
            if (DockerRootDir != null ? !DockerRootDir.equals(that.DockerRootDir) :that.DockerRootDir != null) return false;
            if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
            if (DriverStatus != null ? !DriverStatus.equals(that.DriverStatus) :that.DriverStatus != null) return false;
            if (ExecutionDriver != null ? !ExecutionDriver.equals(that.ExecutionDriver) :that.ExecutionDriver != null) return false;
            if (ExperimentalBuild != null ? !ExperimentalBuild.equals(that.ExperimentalBuild) :that.ExperimentalBuild != null) return false;
            if (HttpProxy != null ? !HttpProxy.equals(that.HttpProxy) :that.HttpProxy != null) return false;
            if (HttpsProxy != null ? !HttpsProxy.equals(that.HttpsProxy) :that.HttpsProxy != null) return false;
            if (ID != null ? !ID.equals(that.ID) :that.ID != null) return false;
            if (IPv4Forwarding != null ? !IPv4Forwarding.equals(that.IPv4Forwarding) :that.IPv4Forwarding != null) return false;
            if (Images != null ? !Images.equals(that.Images) :that.Images != null) return false;
            if (IndexServerAddress != null ? !IndexServerAddress.equals(that.IndexServerAddress) :that.IndexServerAddress != null) return false;
            if (InitPath != null ? !InitPath.equals(that.InitPath) :that.InitPath != null) return false;
            if (InitSha1 != null ? !InitSha1.equals(that.InitSha1) :that.InitSha1 != null) return false;
            if (KernelVersion != null ? !KernelVersion.equals(that.KernelVersion) :that.KernelVersion != null) return false;
            if (Labels != null ? !Labels.equals(that.Labels) :that.Labels != null) return false;
            if (LoggingDriver != null ? !LoggingDriver.equals(that.LoggingDriver) :that.LoggingDriver != null) return false;
            if (MemTotal != null ? !MemTotal.equals(that.MemTotal) :that.MemTotal != null) return false;
            if (MemoryLimit != null ? !MemoryLimit.equals(that.MemoryLimit) :that.MemoryLimit != null) return false;
            if (NCPU != null ? !NCPU.equals(that.NCPU) :that.NCPU != null) return false;
            if (NEventsListener != null ? !NEventsListener.equals(that.NEventsListener) :that.NEventsListener != null) return false;
            if (NFd != null ? !NFd.equals(that.NFd) :that.NFd != null) return false;
            if (NGoroutines != null ? !NGoroutines.equals(that.NGoroutines) :that.NGoroutines != null) return false;
            if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
            if (NoProxy != null ? !NoProxy.equals(that.NoProxy) :that.NoProxy != null) return false;
            if (OomKillDisable != null ? !OomKillDisable.equals(that.OomKillDisable) :that.OomKillDisable != null) return false;
            if (OperatingSystem != null ? !OperatingSystem.equals(that.OperatingSystem) :that.OperatingSystem != null) return false;
            if (RegistryConfig != null ? !RegistryConfig.equals(that.RegistryConfig) :that.RegistryConfig != null) return false;
            if (ServerVersion != null ? !ServerVersion.equals(that.ServerVersion) :that.ServerVersion != null) return false;
            if (SwapLimit != null ? !SwapLimit.equals(that.SwapLimit) :that.SwapLimit != null) return false;
            if (SystemTime != null ? !SystemTime.equals(that.SystemTime) :that.SystemTime != null) return false;
            return true;
    }


    public class RegistryConfigNestedImpl<N> extends ServiceConfigFluentImpl<InfoFluent.RegistryConfigNested<N>> implements InfoFluent.RegistryConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ServiceConfigBuilder builder;
    
            RegistryConfigNestedImpl(ServiceConfig item){
                    this.builder = new ServiceConfigBuilder(this, item);
            }
            RegistryConfigNestedImpl(){
                    this.builder = new ServiceConfigBuilder(this);
            }
    
    public N and(){
            return (N) InfoFluentImpl.this.withRegistryConfig(builder.build());
    }
    public N endRegistryConfig(){
            return and();
    }

}


}
