package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import io.fabric8.docker.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface InfoFluent<A extends InfoFluent<A>> extends Fluent<A>{


    public Boolean isBridgeNfIp6tables();
    public A withBridgeNfIp6tables(Boolean BridgeNfIp6tables);
    public Boolean isBridgeNfIptables();
    public A withBridgeNfIptables(Boolean BridgeNfIptables);
    public String getClusterAdvertise();
    public A withClusterAdvertise(String ClusterAdvertise);
    public String getClusterStore();
    public A withClusterStore(String ClusterStore);
    public Integer getContainers();
    public A withContainers(Integer Containers);
    public Boolean isCpuCfsPeriod();
    public A withCpuCfsPeriod(Boolean CpuCfsPeriod);
    public Boolean isCpuCfsQuota();
    public A withCpuCfsQuota(Boolean CpuCfsQuota);
    public Boolean isDebug();
    public A withDebug(Boolean Debug);
    public String getDockerRootDir();
    public A withDockerRootDir(String DockerRootDir);
    public String getDriver();
    public A withDriver(String Driver);
    public A addToDriverStatus(Object... items);
    public A removeFromDriverStatus(Object... items);
    public List<Object> getDriverStatus();
    public A withDriverStatus(List<Object> DriverStatus);
    public A withDriverStatus(Object... DriverStatus);
    public String getExecutionDriver();
    public A withExecutionDriver(String ExecutionDriver);
    public Boolean isExperimentalBuild();
    public A withExperimentalBuild(Boolean ExperimentalBuild);
    public String getHttpProxy();
    public A withHttpProxy(String HttpProxy);
    public String getHttpsProxy();
    public A withHttpsProxy(String HttpsProxy);
    public String getID();
    public A withID(String ID);
    public Boolean isIPv4Forwarding();
    public A withIPv4Forwarding(Boolean IPv4Forwarding);
    public Integer getImages();
    public A withImages(Integer Images);
    public String getIndexServerAddress();
    public A withIndexServerAddress(String IndexServerAddress);
    public String getInitPath();
    public A withInitPath(String InitPath);
    public String getInitSha1();
    public A withInitSha1(String InitSha1);
    public String getKernelVersion();
    public A withKernelVersion(String KernelVersion);
    public A addToLabels(String... items);
    public A removeFromLabels(String... items);
    public List<String> getLabels();
    public A withLabels(List<String> Labels);
    public A withLabels(String... Labels);
    public String getLoggingDriver();
    public A withLoggingDriver(String LoggingDriver);
    public Long getMemTotal();
    public A withMemTotal(Long MemTotal);
    public Boolean isMemoryLimit();
    public A withMemoryLimit(Boolean MemoryLimit);
    public Integer getNCPU();
    public A withNCPU(Integer NCPU);
    public Integer getNEventsListener();
    public A withNEventsListener(Integer NEventsListener);
    public Integer getNFd();
    public A withNFd(Integer NFd);
    public Integer getNGoroutines();
    public A withNGoroutines(Integer NGoroutines);
    public String getName();
    public A withName(String Name);
    public String getNoProxy();
    public A withNoProxy(String NoProxy);
    public Boolean isOomKillDisable();
    public A withOomKillDisable(Boolean OomKillDisable);
    public String getOperatingSystem();
    public A withOperatingSystem(String OperatingSystem);
    public ServiceConfig getRegistryConfig();
    public A withRegistryConfig(ServiceConfig RegistryConfig);
    public InfoFluent.RegistryConfigNested<A> withNewRegistryConfig();
    public InfoFluent.RegistryConfigNested<A> withNewRegistryConfigLike(ServiceConfig item);
    public InfoFluent.RegistryConfigNested<A> editRegistryConfig();
    public InfoFluent.RegistryConfigNested<A> editOrNewRegistryConfig();
    public InfoFluent.RegistryConfigNested<A> editOrNewRegistryConfigLike(ServiceConfig item);
    public String getServerVersion();
    public A withServerVersion(String ServerVersion);
    public Boolean isSwapLimit();
    public A withSwapLimit(Boolean SwapLimit);
    public String getSystemTime();
    public A withSystemTime(String SystemTime);

    public interface RegistryConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ServiceConfigFluent<InfoFluent.RegistryConfigNested<N>>{

        
    public N and();    public N endRegistryConfig();
}


}
