package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class IndexInfoBuilder extends IndexInfoFluentImpl<IndexInfoBuilder> implements VisitableBuilder<IndexInfo,IndexInfoBuilder>{

    IndexInfoFluent<?> fluent;
    Boolean validationEnabled;

    public IndexInfoBuilder(){
            this(true);
    }
    public IndexInfoBuilder(Boolean validationEnabled){
            this(new IndexInfo(), validationEnabled);
    }
    public IndexInfoBuilder(IndexInfoFluent<?> fluent){
            this(fluent, true);
    }
    public IndexInfoBuilder(IndexInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IndexInfo(), validationEnabled);
    }
    public IndexInfoBuilder(IndexInfoFluent<?> fluent,IndexInfo instance){
            this(fluent, instance, true);
    }
    public IndexInfoBuilder(IndexInfoFluent<?> fluent,IndexInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMirrors(instance.getMirrors()); 
            fluent.withName(instance.getName()); 
            fluent.withOfficial(instance.getOfficial()); 
            fluent.withSecure(instance.getSecure()); 
            this.validationEnabled = validationEnabled; 
    }
    public IndexInfoBuilder(IndexInfo instance){
            this(instance,true);
    }
    public IndexInfoBuilder(IndexInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMirrors(instance.getMirrors()); 
            this.withName(instance.getName()); 
            this.withOfficial(instance.getOfficial()); 
            this.withSecure(instance.getSecure()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableIndexInfo build(){
            EditableIndexInfo buildable = new EditableIndexInfo(fluent.getMirrors(),fluent.getName(),fluent.isOfficial(),fluent.isSecure());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IndexInfoBuilder that = (IndexInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
