package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class ImageInspectFluentImpl<A extends ImageInspectFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ImageInspectFluent<A>{

    private String Architecture;
    private String Author;
    private String Comment;
    private VisitableBuilder<? extends Config,?> Config;
    private String Container;
    private VisitableBuilder<? extends Config,?> ContainerConfig;
    private String Created;
    private String DockerVersion;
    private VisitableBuilder<? extends GraphDriverData,?> GraphDriver;
    private String Id;
    private String Os;
    private String Parent;
    private List<String> RepoDigests = new ArrayList<String>();
    private List<String> RepoTags = new ArrayList<String>();
    private Long Size;
    private Long VirtualSize;

    public ImageInspectFluentImpl(){
    }
    public ImageInspectFluentImpl(ImageInspect instance){
            this.withArchitecture(instance.getArchitecture()); 
            this.withAuthor(instance.getAuthor()); 
            this.withComment(instance.getComment()); 
            this.withConfig(instance.getConfig()); 
            this.withContainer(instance.getContainer()); 
            this.withContainerConfig(instance.getContainerConfig()); 
            this.withCreated(instance.getCreated()); 
            this.withDockerVersion(instance.getDockerVersion()); 
            this.withGraphDriver(instance.getGraphDriver()); 
            this.withId(instance.getId()); 
            this.withOs(instance.getOs()); 
            this.withParent(instance.getParent()); 
            this.withRepoDigests(instance.getRepoDigests()); 
            this.withRepoTags(instance.getRepoTags()); 
            this.withSize(instance.getSize()); 
            this.withVirtualSize(instance.getVirtualSize()); 
    }

    public String getArchitecture(){
            return this.Architecture;
    }

    public A withArchitecture(String Architecture){
            this.Architecture=Architecture; return (A) this;
    }

    public String getAuthor(){
            return this.Author;
    }

    public A withAuthor(String Author){
            this.Author=Author; return (A) this;
    }

    public String getComment(){
            return this.Comment;
    }

    public A withComment(String Comment){
            this.Comment=Comment; return (A) this;
    }

    public Config getConfig(){
            return this.Config!=null?this.Config.build():null;
    }

    public A withConfig(Config Config){
            _visitables.remove(this.Config);
            if (Config!=null){ this.Config= new ConfigBuilder(Config); _visitables.add(this.Config);} return (A) this;
    }

    public ImageInspectFluent.ConfigNested<A> withNewConfig(){
            return new ConfigNestedImpl();
    }

    public ImageInspectFluent.ConfigNested<A> withNewConfigLike(Config item){
            return new ConfigNestedImpl(item);
    }

    public ImageInspectFluent.ConfigNested<A> editConfig(){
            return withNewConfigLike(getConfig());
    }

    public ImageInspectFluent.ConfigNested<A> editOrNewConfig(){
            return withNewConfigLike(getConfig() != null ? getConfig(): new ConfigBuilder().build());
    }

    public ImageInspectFluent.ConfigNested<A> editOrNewConfigLike(Config item){
            return withNewConfigLike(getConfig() != null ? getConfig(): item);
    }

    public String getContainer(){
            return this.Container;
    }

    public A withContainer(String Container){
            this.Container=Container; return (A) this;
    }

    public Config getContainerConfig(){
            return this.ContainerConfig!=null?this.ContainerConfig.build():null;
    }

    public A withContainerConfig(Config ContainerConfig){
            _visitables.remove(this.ContainerConfig);
            if (ContainerConfig!=null){ this.ContainerConfig= new ConfigBuilder(ContainerConfig); _visitables.add(this.ContainerConfig);} return (A) this;
    }

    public ImageInspectFluent.ContainerConfigNested<A> withNewContainerConfig(){
            return new ContainerConfigNestedImpl();
    }

    public ImageInspectFluent.ContainerConfigNested<A> withNewContainerConfigLike(Config item){
            return new ContainerConfigNestedImpl(item);
    }

    public ImageInspectFluent.ContainerConfigNested<A> editContainerConfig(){
            return withNewContainerConfigLike(getContainerConfig());
    }

    public ImageInspectFluent.ContainerConfigNested<A> editOrNewContainerConfig(){
            return withNewContainerConfigLike(getContainerConfig() != null ? getContainerConfig(): new ConfigBuilder().build());
    }

    public ImageInspectFluent.ContainerConfigNested<A> editOrNewContainerConfigLike(Config item){
            return withNewContainerConfigLike(getContainerConfig() != null ? getContainerConfig(): item);
    }

    public String getCreated(){
            return this.Created;
    }

    public A withCreated(String Created){
            this.Created=Created; return (A) this;
    }

    public String getDockerVersion(){
            return this.DockerVersion;
    }

    public A withDockerVersion(String DockerVersion){
            this.DockerVersion=DockerVersion; return (A) this;
    }

    public GraphDriverData getGraphDriver(){
            return this.GraphDriver!=null?this.GraphDriver.build():null;
    }

    public A withGraphDriver(GraphDriverData GraphDriver){
            _visitables.remove(this.GraphDriver);
            if (GraphDriver!=null){ this.GraphDriver= new GraphDriverDataBuilder(GraphDriver); _visitables.add(this.GraphDriver);} return (A) this;
    }

    public ImageInspectFluent.GraphDriverNested<A> withNewGraphDriver(){
            return new GraphDriverNestedImpl();
    }

    public ImageInspectFluent.GraphDriverNested<A> withNewGraphDriverLike(GraphDriverData item){
            return new GraphDriverNestedImpl(item);
    }

    public ImageInspectFluent.GraphDriverNested<A> editGraphDriver(){
            return withNewGraphDriverLike(getGraphDriver());
    }

    public ImageInspectFluent.GraphDriverNested<A> editOrNewGraphDriver(){
            return withNewGraphDriverLike(getGraphDriver() != null ? getGraphDriver(): new GraphDriverDataBuilder().build());
    }

    public ImageInspectFluent.GraphDriverNested<A> editOrNewGraphDriverLike(GraphDriverData item){
            return withNewGraphDriverLike(getGraphDriver() != null ? getGraphDriver(): item);
    }

    public String getId(){
            return this.Id;
    }

    public A withId(String Id){
            this.Id=Id; return (A) this;
    }

    public String getOs(){
            return this.Os;
    }

    public A withOs(String Os){
            this.Os=Os; return (A) this;
    }

    public String getParent(){
            return this.Parent;
    }

    public A withParent(String Parent){
            this.Parent=Parent; return (A) this;
    }

    public A addToRepoDigests(String... items){
            for (String item : items) {this.RepoDigests.add(item);} return (A)this;
    }

    public A removeFromRepoDigests(String... items){
            for (String item : items) {this.RepoDigests.remove(item);} return (A)this;
    }

    public List<String> getRepoDigests(){
            return this.RepoDigests;
    }

    public A withRepoDigests(List<String> RepoDigests){
            this.RepoDigests.clear();
            if (RepoDigests != null) {for (String item : RepoDigests){this.addToRepoDigests(item);}} return (A) this;
    }

    public A withRepoDigests(String... RepoDigests){
            this.RepoDigests.clear(); if (RepoDigests != null) {for (String item :RepoDigests){ this.addToRepoDigests(item);}} return (A) this;
    }

    public A addToRepoTags(String... items){
            for (String item : items) {this.RepoTags.add(item);} return (A)this;
    }

    public A removeFromRepoTags(String... items){
            for (String item : items) {this.RepoTags.remove(item);} return (A)this;
    }

    public List<String> getRepoTags(){
            return this.RepoTags;
    }

    public A withRepoTags(List<String> RepoTags){
            this.RepoTags.clear();
            if (RepoTags != null) {for (String item : RepoTags){this.addToRepoTags(item);}} return (A) this;
    }

    public A withRepoTags(String... RepoTags){
            this.RepoTags.clear(); if (RepoTags != null) {for (String item :RepoTags){ this.addToRepoTags(item);}} return (A) this;
    }

    public Long getSize(){
            return this.Size;
    }

    public A withSize(Long Size){
            this.Size=Size; return (A) this;
    }

    public Long getVirtualSize(){
            return this.VirtualSize;
    }

    public A withVirtualSize(Long VirtualSize){
            this.VirtualSize=VirtualSize; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageInspectFluentImpl that = (ImageInspectFluentImpl) o;
            if (Architecture != null ? !Architecture.equals(that.Architecture) :that.Architecture != null) return false;
            if (Author != null ? !Author.equals(that.Author) :that.Author != null) return false;
            if (Comment != null ? !Comment.equals(that.Comment) :that.Comment != null) return false;
            if (Config != null ? !Config.equals(that.Config) :that.Config != null) return false;
            if (Container != null ? !Container.equals(that.Container) :that.Container != null) return false;
            if (ContainerConfig != null ? !ContainerConfig.equals(that.ContainerConfig) :that.ContainerConfig != null) return false;
            if (Created != null ? !Created.equals(that.Created) :that.Created != null) return false;
            if (DockerVersion != null ? !DockerVersion.equals(that.DockerVersion) :that.DockerVersion != null) return false;
            if (GraphDriver != null ? !GraphDriver.equals(that.GraphDriver) :that.GraphDriver != null) return false;
            if (Id != null ? !Id.equals(that.Id) :that.Id != null) return false;
            if (Os != null ? !Os.equals(that.Os) :that.Os != null) return false;
            if (Parent != null ? !Parent.equals(that.Parent) :that.Parent != null) return false;
            if (RepoDigests != null ? !RepoDigests.equals(that.RepoDigests) :that.RepoDigests != null) return false;
            if (RepoTags != null ? !RepoTags.equals(that.RepoTags) :that.RepoTags != null) return false;
            if (Size != null ? !Size.equals(that.Size) :that.Size != null) return false;
            if (VirtualSize != null ? !VirtualSize.equals(that.VirtualSize) :that.VirtualSize != null) return false;
            return true;
    }


    public class ConfigNestedImpl<N> extends ConfigFluentImpl<ImageInspectFluent.ConfigNested<N>> implements ImageInspectFluent.ConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ConfigBuilder builder;
    
            ConfigNestedImpl(Config item){
                    this.builder = new ConfigBuilder(this, item);
            }
            ConfigNestedImpl(){
                    this.builder = new ConfigBuilder(this);
            }
    
    public N and(){
            return (N) ImageInspectFluentImpl.this.withConfig(builder.build());
    }
    public N endConfig(){
            return and();
    }

}
    public class ContainerConfigNestedImpl<N> extends ConfigFluentImpl<ImageInspectFluent.ContainerConfigNested<N>> implements ImageInspectFluent.ContainerConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ConfigBuilder builder;
    
            ContainerConfigNestedImpl(Config item){
                    this.builder = new ConfigBuilder(this, item);
            }
            ContainerConfigNestedImpl(){
                    this.builder = new ConfigBuilder(this);
            }
    
    public N and(){
            return (N) ImageInspectFluentImpl.this.withContainerConfig(builder.build());
    }
    public N endContainerConfig(){
            return and();
    }

}
    public class GraphDriverNestedImpl<N> extends GraphDriverDataFluentImpl<ImageInspectFluent.GraphDriverNested<N>> implements ImageInspectFluent.GraphDriverNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final GraphDriverDataBuilder builder;
    
            GraphDriverNestedImpl(GraphDriverData item){
                    this.builder = new GraphDriverDataBuilder(this, item);
            }
            GraphDriverNestedImpl(){
                    this.builder = new GraphDriverDataBuilder(this);
            }
    
    public N and(){
            return (N) ImageInspectFluentImpl.this.withGraphDriver(builder.build());
    }
    public N endGraphDriver(){
            return and();
    }

}


}
