package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.docker.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ImageInspectFluent<A extends ImageInspectFluent<A>> extends Fluent<A>{


    public String getArchitecture();
    public A withArchitecture(String Architecture);
    public String getAuthor();
    public A withAuthor(String Author);
    public String getComment();
    public A withComment(String Comment);
    public Config getConfig();
    public A withConfig(Config Config);
    public ImageInspectFluent.ConfigNested<A> withNewConfig();
    public ImageInspectFluent.ConfigNested<A> withNewConfigLike(Config item);
    public ImageInspectFluent.ConfigNested<A> editConfig();
    public ImageInspectFluent.ConfigNested<A> editOrNewConfig();
    public ImageInspectFluent.ConfigNested<A> editOrNewConfigLike(Config item);
    public String getContainer();
    public A withContainer(String Container);
    public Config getContainerConfig();
    public A withContainerConfig(Config ContainerConfig);
    public ImageInspectFluent.ContainerConfigNested<A> withNewContainerConfig();
    public ImageInspectFluent.ContainerConfigNested<A> withNewContainerConfigLike(Config item);
    public ImageInspectFluent.ContainerConfigNested<A> editContainerConfig();
    public ImageInspectFluent.ContainerConfigNested<A> editOrNewContainerConfig();
    public ImageInspectFluent.ContainerConfigNested<A> editOrNewContainerConfigLike(Config item);
    public String getCreated();
    public A withCreated(String Created);
    public String getDockerVersion();
    public A withDockerVersion(String DockerVersion);
    public GraphDriverData getGraphDriver();
    public A withGraphDriver(GraphDriverData GraphDriver);
    public ImageInspectFluent.GraphDriverNested<A> withNewGraphDriver();
    public ImageInspectFluent.GraphDriverNested<A> withNewGraphDriverLike(GraphDriverData item);
    public ImageInspectFluent.GraphDriverNested<A> editGraphDriver();
    public ImageInspectFluent.GraphDriverNested<A> editOrNewGraphDriver();
    public ImageInspectFluent.GraphDriverNested<A> editOrNewGraphDriverLike(GraphDriverData item);
    public String getId();
    public A withId(String Id);
    public String getOs();
    public A withOs(String Os);
    public String getParent();
    public A withParent(String Parent);
    public A addToRepoDigests(String... items);
    public A removeFromRepoDigests(String... items);
    public List<String> getRepoDigests();
    public A withRepoDigests(List<String> RepoDigests);
    public A withRepoDigests(String... RepoDigests);
    public A addToRepoTags(String... items);
    public A removeFromRepoTags(String... items);
    public List<String> getRepoTags();
    public A withRepoTags(List<String> RepoTags);
    public A withRepoTags(String... RepoTags);
    public Long getSize();
    public A withSize(Long Size);
    public Long getVirtualSize();
    public A withVirtualSize(Long VirtualSize);

    public interface ConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ConfigFluent<ImageInspectFluent.ConfigNested<N>>{

        
    public N and();    public N endConfig();
}
    public interface ContainerConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ConfigFluent<ImageInspectFluent.ContainerConfigNested<N>>{

        
    public N and();    public N endContainerConfig();
}
    public interface GraphDriverNested<N> extends io.fabric8.docker.api.builder.Nested<N>,GraphDriverDataFluent<ImageInspectFluent.GraphDriverNested<N>>{

        
    public N and();    public N endGraphDriver();
}


}
