package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ImageInspectBuilder extends ImageInspectFluentImpl<ImageInspectBuilder> implements VisitableBuilder<ImageInspect,ImageInspectBuilder>{

    ImageInspectFluent<?> fluent;
    Boolean validationEnabled;

    public ImageInspectBuilder(){
            this(true);
    }
    public ImageInspectBuilder(Boolean validationEnabled){
            this(new ImageInspect(), validationEnabled);
    }
    public ImageInspectBuilder(ImageInspectFluent<?> fluent){
            this(fluent, true);
    }
    public ImageInspectBuilder(ImageInspectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageInspect(), validationEnabled);
    }
    public ImageInspectBuilder(ImageInspectFluent<?> fluent,ImageInspect instance){
            this(fluent, instance, true);
    }
    public ImageInspectBuilder(ImageInspectFluent<?> fluent,ImageInspect instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withArchitecture(instance.getArchitecture()); 
            fluent.withAuthor(instance.getAuthor()); 
            fluent.withComment(instance.getComment()); 
            fluent.withConfig(instance.getConfig()); 
            fluent.withContainer(instance.getContainer()); 
            fluent.withContainerConfig(instance.getContainerConfig()); 
            fluent.withCreated(instance.getCreated()); 
            fluent.withDockerVersion(instance.getDockerVersion()); 
            fluent.withGraphDriver(instance.getGraphDriver()); 
            fluent.withId(instance.getId()); 
            fluent.withOs(instance.getOs()); 
            fluent.withParent(instance.getParent()); 
            fluent.withRepoDigests(instance.getRepoDigests()); 
            fluent.withRepoTags(instance.getRepoTags()); 
            fluent.withSize(instance.getSize()); 
            fluent.withVirtualSize(instance.getVirtualSize()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageInspectBuilder(ImageInspect instance){
            this(instance,true);
    }
    public ImageInspectBuilder(ImageInspect instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withArchitecture(instance.getArchitecture()); 
            this.withAuthor(instance.getAuthor()); 
            this.withComment(instance.getComment()); 
            this.withConfig(instance.getConfig()); 
            this.withContainer(instance.getContainer()); 
            this.withContainerConfig(instance.getContainerConfig()); 
            this.withCreated(instance.getCreated()); 
            this.withDockerVersion(instance.getDockerVersion()); 
            this.withGraphDriver(instance.getGraphDriver()); 
            this.withId(instance.getId()); 
            this.withOs(instance.getOs()); 
            this.withParent(instance.getParent()); 
            this.withRepoDigests(instance.getRepoDigests()); 
            this.withRepoTags(instance.getRepoTags()); 
            this.withSize(instance.getSize()); 
            this.withVirtualSize(instance.getVirtualSize()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableImageInspect build(){
            EditableImageInspect buildable = new EditableImageInspect(fluent.getArchitecture(),fluent.getAuthor(),fluent.getComment(),fluent.getConfig(),fluent.getContainer(),fluent.getContainerConfig(),fluent.getCreated(),fluent.getDockerVersion(),fluent.getGraphDriver(),fluent.getId(),fluent.getOs(),fluent.getParent(),fluent.getRepoDigests(),fluent.getRepoTags(),fluent.getSize(),fluent.getVirtualSize());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageInspectBuilder that = (ImageInspectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
