package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ImageHistoryBuilder extends ImageHistoryFluentImpl<ImageHistoryBuilder> implements VisitableBuilder<ImageHistory,ImageHistoryBuilder>{

    ImageHistoryFluent<?> fluent;
    Boolean validationEnabled;

    public ImageHistoryBuilder(){
            this(true);
    }
    public ImageHistoryBuilder(Boolean validationEnabled){
            this(new ImageHistory(), validationEnabled);
    }
    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent){
            this(fluent, true);
    }
    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageHistory(), validationEnabled);
    }
    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent,ImageHistory instance){
            this(fluent, instance, true);
    }
    public ImageHistoryBuilder(ImageHistoryFluent<?> fluent,ImageHistory instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withComment(instance.getComment()); 
            fluent.withCreated(instance.getCreated()); 
            fluent.withCreatedBy(instance.getCreatedBy()); 
            fluent.withId(instance.getId()); 
            fluent.withSize(instance.getSize()); 
            fluent.withTags(instance.getTags()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageHistoryBuilder(ImageHistory instance){
            this(instance,true);
    }
    public ImageHistoryBuilder(ImageHistory instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withComment(instance.getComment()); 
            this.withCreated(instance.getCreated()); 
            this.withCreatedBy(instance.getCreatedBy()); 
            this.withId(instance.getId()); 
            this.withSize(instance.getSize()); 
            this.withTags(instance.getTags()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableImageHistory build(){
            EditableImageHistory buildable = new EditableImageHistory(fluent.getComment(),fluent.getCreated(),fluent.getCreatedBy(),fluent.getId(),fluent.getSize(),fluent.getTags());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageHistoryBuilder that = (ImageHistoryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
