package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ImageBuilder extends ImageFluentImpl<ImageBuilder> implements VisitableBuilder<Image,ImageBuilder>{

    ImageFluent<?> fluent;
    Boolean validationEnabled;

    public ImageBuilder(){
            this(true);
    }
    public ImageBuilder(Boolean validationEnabled){
            this(new Image(), validationEnabled);
    }
    public ImageBuilder(ImageFluent<?> fluent){
            this(fluent, true);
    }
    public ImageBuilder(ImageFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Image(), validationEnabled);
    }
    public ImageBuilder(ImageFluent<?> fluent,Image instance){
            this(fluent, instance, true);
    }
    public ImageBuilder(ImageFluent<?> fluent,Image instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCreated(instance.getCreated()); 
            fluent.withId(instance.getId()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withParentId(instance.getParentId()); 
            fluent.withRepoDigests(instance.getRepoDigests()); 
            fluent.withRepoTags(instance.getRepoTags()); 
            fluent.withSize(instance.getSize()); 
            fluent.withVirtualSize(instance.getVirtualSize()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageBuilder(Image instance){
            this(instance,true);
    }
    public ImageBuilder(Image instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCreated(instance.getCreated()); 
            this.withId(instance.getId()); 
            this.withLabels(instance.getLabels()); 
            this.withParentId(instance.getParentId()); 
            this.withRepoDigests(instance.getRepoDigests()); 
            this.withRepoTags(instance.getRepoTags()); 
            this.withSize(instance.getSize()); 
            this.withVirtualSize(instance.getVirtualSize()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableImage build(){
            EditableImage buildable = new EditableImage(fluent.getCreated(),fluent.getId(),fluent.getLabels(),fluent.getParentId(),fluent.getRepoDigests(),fluent.getRepoTags(),fluent.getSize(),fluent.getVirtualSize());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageBuilder that = (ImageBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
