package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class IPAMConfigBuilder extends IPAMConfigFluentImpl<IPAMConfigBuilder> implements VisitableBuilder<IPAMConfig,IPAMConfigBuilder>{

    IPAMConfigFluent<?> fluent;
    Boolean validationEnabled;

    public IPAMConfigBuilder(){
            this(true);
    }
    public IPAMConfigBuilder(Boolean validationEnabled){
            this(new IPAMConfig(), validationEnabled);
    }
    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent){
            this(fluent, true);
    }
    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IPAMConfig(), validationEnabled);
    }
    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,IPAMConfig instance){
            this(fluent, instance, true);
    }
    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,IPAMConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuxiliaryAddresses(instance.getAuxiliaryAddresses()); 
            fluent.withGateway(instance.getGateway()); 
            fluent.withIPRange(instance.getIPRange()); 
            fluent.withSubnet(instance.getSubnet()); 
            this.validationEnabled = validationEnabled; 
    }
    public IPAMConfigBuilder(IPAMConfig instance){
            this(instance,true);
    }
    public IPAMConfigBuilder(IPAMConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuxiliaryAddresses(instance.getAuxiliaryAddresses()); 
            this.withGateway(instance.getGateway()); 
            this.withIPRange(instance.getIPRange()); 
            this.withSubnet(instance.getSubnet()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableIPAMConfig build(){
            EditableIPAMConfig buildable = new EditableIPAMConfig(fluent.getAuxiliaryAddresses(),fluent.getGateway(),fluent.getIPRange(),fluent.getSubnet());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IPAMConfigBuilder that = (IPAMConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
