package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class IPAMBuilder extends IPAMFluentImpl<IPAMBuilder> implements VisitableBuilder<IPAM,IPAMBuilder>{

    IPAMFluent<?> fluent;
    Boolean validationEnabled;

    public IPAMBuilder(){
            this(true);
    }
    public IPAMBuilder(Boolean validationEnabled){
            this(new IPAM(), validationEnabled);
    }
    public IPAMBuilder(IPAMFluent<?> fluent){
            this(fluent, true);
    }
    public IPAMBuilder(IPAMFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IPAM(), validationEnabled);
    }
    public IPAMBuilder(IPAMFluent<?> fluent,IPAM instance){
            this(fluent, instance, true);
    }
    public IPAMBuilder(IPAMFluent<?> fluent,IPAM instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfig(instance.getConfig()); 
            fluent.withDriver(instance.getDriver()); 
            this.validationEnabled = validationEnabled; 
    }
    public IPAMBuilder(IPAM instance){
            this(instance,true);
    }
    public IPAMBuilder(IPAM instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfig(instance.getConfig()); 
            this.withDriver(instance.getDriver()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableIPAM build(){
            EditableIPAM buildable = new EditableIPAM(fluent.getConfig(),fluent.getDriver());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IPAMBuilder that = (IPAMBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
