package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class HostConfigFluentImpl<A extends HostConfigFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements HostConfigFluent<A>{

    private List<String> Binds = new ArrayList<String>();
    private Integer BlkioWeight;
    private List<String> CapAdd = new ArrayList<String>();
    private List<String> CapDrop = new ArrayList<String>();
    private String CgroupParent;
    private Object ConsoleSize;
    private String ContainerIDFile;
    private Long CpuPeriod;
    private Long CpuQuota;
    private Long CpuShares;
    private String CpusetCpus;
    private String CpusetMems;
    private List<VisitableBuilder<? extends DeviceMapping,?>> Devices =  new ArrayList<VisitableBuilder<? extends DeviceMapping,?>>();
    private List<String> Dns = new ArrayList<String>();
    private List<String> DnsOptions = new ArrayList<String>();
    private List<String> DnsSearch = new ArrayList<String>();
    private List<String> ExtraHosts = new ArrayList<String>();
    private List<String> GroupAdd = new ArrayList<String>();
    private String IpcMode;
    private Long KernelMemory;
    private List<String> Links = new ArrayList<String>();
    private VisitableBuilder<? extends LogConfig,?> LogConfig;
    private LxcConfig LxcConf;
    private Long Memory;
    private Long MemoryReservation;
    private Long MemorySwap;
    private Long MemorySwappiness;
    private String NetworkMode;
    private Boolean OomKillDisable;
    private String PidMode;
    private Map<String,ArrayList<PortBinding>> PortBindings = new LinkedHashMap<String,ArrayList<PortBinding>>();
    private Boolean Privileged;
    private Boolean PublishAllPorts;
    private Boolean ReadonlyRootfs;
    private VisitableBuilder<? extends RestartPolicy,?> RestartPolicy;
    private List<String> SecurityOpt = new ArrayList<String>();
    private String UTSMode;
    private List<VisitableBuilder<? extends Ulimit,?>> Ulimits =  new ArrayList<VisitableBuilder<? extends Ulimit,?>>();
    private String VolumeDriver;
    private List<String> VolumesFrom = new ArrayList<String>();

    public HostConfigFluentImpl(){
    }
    public HostConfigFluentImpl(HostConfig instance){
            this.withBinds(instance.getBinds()); 
            this.withBlkioWeight(instance.getBlkioWeight()); 
            this.withCapAdd(instance.getCapAdd()); 
            this.withCapDrop(instance.getCapDrop()); 
            this.withCgroupParent(instance.getCgroupParent()); 
            this.withConsoleSize(instance.getConsoleSize()); 
            this.withContainerIDFile(instance.getContainerIDFile()); 
            this.withCpuPeriod(instance.getCpuPeriod()); 
            this.withCpuQuota(instance.getCpuQuota()); 
            this.withCpuShares(instance.getCpuShares()); 
            this.withCpusetCpus(instance.getCpusetCpus()); 
            this.withCpusetMems(instance.getCpusetMems()); 
            this.withDevices(instance.getDevices()); 
            this.withDns(instance.getDns()); 
            this.withDnsOptions(instance.getDnsOptions()); 
            this.withDnsSearch(instance.getDnsSearch()); 
            this.withExtraHosts(instance.getExtraHosts()); 
            this.withGroupAdd(instance.getGroupAdd()); 
            this.withIpcMode(instance.getIpcMode()); 
            this.withKernelMemory(instance.getKernelMemory()); 
            this.withLinks(instance.getLinks()); 
            this.withLogConfig(instance.getLogConfig()); 
            this.withLxcConf(instance.getLxcConf()); 
            this.withMemory(instance.getMemory()); 
            this.withMemoryReservation(instance.getMemoryReservation()); 
            this.withMemorySwap(instance.getMemorySwap()); 
            this.withMemorySwappiness(instance.getMemorySwappiness()); 
            this.withNetworkMode(instance.getNetworkMode()); 
            this.withOomKillDisable(instance.getOomKillDisable()); 
            this.withPidMode(instance.getPidMode()); 
            this.withPortBindings(instance.getPortBindings()); 
            this.withPrivileged(instance.getPrivileged()); 
            this.withPublishAllPorts(instance.getPublishAllPorts()); 
            this.withReadonlyRootfs(instance.getReadonlyRootfs()); 
            this.withRestartPolicy(instance.getRestartPolicy()); 
            this.withSecurityOpt(instance.getSecurityOpt()); 
            this.withUTSMode(instance.getUTSMode()); 
            this.withUlimits(instance.getUlimits()); 
            this.withVolumeDriver(instance.getVolumeDriver()); 
            this.withVolumesFrom(instance.getVolumesFrom()); 
    }

    public A addToBinds(String... items){
            for (String item : items) {this.Binds.add(item);} return (A)this;
    }

    public A removeFromBinds(String... items){
            for (String item : items) {this.Binds.remove(item);} return (A)this;
    }

    public List<String> getBinds(){
            return this.Binds;
    }

    public A withBinds(List<String> Binds){
            this.Binds.clear();
            if (Binds != null) {for (String item : Binds){this.addToBinds(item);}} return (A) this;
    }

    public A withBinds(String... Binds){
            this.Binds.clear(); if (Binds != null) {for (String item :Binds){ this.addToBinds(item);}} return (A) this;
    }

    public Integer getBlkioWeight(){
            return this.BlkioWeight;
    }

    public A withBlkioWeight(Integer BlkioWeight){
            this.BlkioWeight=BlkioWeight; return (A) this;
    }

    public A addToCapAdd(String... items){
            for (String item : items) {this.CapAdd.add(item);} return (A)this;
    }

    public A removeFromCapAdd(String... items){
            for (String item : items) {this.CapAdd.remove(item);} return (A)this;
    }

    public List<String> getCapAdd(){
            return this.CapAdd;
    }

    public A withCapAdd(List<String> CapAdd){
            this.CapAdd.clear();
            if (CapAdd != null) {for (String item : CapAdd){this.addToCapAdd(item);}} return (A) this;
    }

    public A withCapAdd(String... CapAdd){
            this.CapAdd.clear(); if (CapAdd != null) {for (String item :CapAdd){ this.addToCapAdd(item);}} return (A) this;
    }

    public A addToCapDrop(String... items){
            for (String item : items) {this.CapDrop.add(item);} return (A)this;
    }

    public A removeFromCapDrop(String... items){
            for (String item : items) {this.CapDrop.remove(item);} return (A)this;
    }

    public List<String> getCapDrop(){
            return this.CapDrop;
    }

    public A withCapDrop(List<String> CapDrop){
            this.CapDrop.clear();
            if (CapDrop != null) {for (String item : CapDrop){this.addToCapDrop(item);}} return (A) this;
    }

    public A withCapDrop(String... CapDrop){
            this.CapDrop.clear(); if (CapDrop != null) {for (String item :CapDrop){ this.addToCapDrop(item);}} return (A) this;
    }

    public String getCgroupParent(){
            return this.CgroupParent;
    }

    public A withCgroupParent(String CgroupParent){
            this.CgroupParent=CgroupParent; return (A) this;
    }

    public Object getConsoleSize(){
            return this.ConsoleSize;
    }

    public A withConsoleSize(Object ConsoleSize){
            this.ConsoleSize=ConsoleSize; return (A) this;
    }

    public String getContainerIDFile(){
            return this.ContainerIDFile;
    }

    public A withContainerIDFile(String ContainerIDFile){
            this.ContainerIDFile=ContainerIDFile; return (A) this;
    }

    public Long getCpuPeriod(){
            return this.CpuPeriod;
    }

    public A withCpuPeriod(Long CpuPeriod){
            this.CpuPeriod=CpuPeriod; return (A) this;
    }

    public Long getCpuQuota(){
            return this.CpuQuota;
    }

    public A withCpuQuota(Long CpuQuota){
            this.CpuQuota=CpuQuota; return (A) this;
    }

    public Long getCpuShares(){
            return this.CpuShares;
    }

    public A withCpuShares(Long CpuShares){
            this.CpuShares=CpuShares; return (A) this;
    }

    public String getCpusetCpus(){
            return this.CpusetCpus;
    }

    public A withCpusetCpus(String CpusetCpus){
            this.CpusetCpus=CpusetCpus; return (A) this;
    }

    public String getCpusetMems(){
            return this.CpusetMems;
    }

    public A withCpusetMems(String CpusetMems){
            this.CpusetMems=CpusetMems; return (A) this;
    }

    public A addToDevices(DeviceMapping... items){
            for (DeviceMapping item : items) {DeviceMappingBuilder builder = new DeviceMappingBuilder(item);_visitables.add(builder);this.Devices.add(builder);} return (A)this;
    }

    public A removeFromDevices(DeviceMapping... items){
            for (DeviceMapping item : items) {DeviceMappingBuilder builder = new DeviceMappingBuilder(item);_visitables.remove(builder);this.Devices.remove(builder);} return (A)this;
    }

    public List<DeviceMapping> getDevices(){
            return build(Devices);
    }

    public A withDevices(List<DeviceMapping> Devices){
            _visitables.removeAll(this.Devices);
            this.Devices.clear();
            if (Devices != null) {for (DeviceMapping item : Devices){this.addToDevices(item);}} return (A) this;
    }

    public A withDevices(DeviceMapping... Devices){
            this.Devices.clear(); if (Devices != null) {for (DeviceMapping item :Devices){ this.addToDevices(item);}} return (A) this;
    }

    public HostConfigFluent.DevicesNested<A> addNewDevice(){
            return new DevicesNestedImpl();
    }

    public HostConfigFluent.DevicesNested<A> addNewDeviceLike(DeviceMapping item){
            return new DevicesNestedImpl(item);
    }

    public A addNewDevice(String CgroupPermissions,String PathInContainer,String PathOnHost){
            return (A)addToDevices(new DeviceMapping(CgroupPermissions, PathInContainer, PathOnHost));
    }

    public A addToDns(String... items){
            for (String item : items) {this.Dns.add(item);} return (A)this;
    }

    public A removeFromDns(String... items){
            for (String item : items) {this.Dns.remove(item);} return (A)this;
    }

    public List<String> getDns(){
            return this.Dns;
    }

    public A withDns(List<String> Dns){
            this.Dns.clear();
            if (Dns != null) {for (String item : Dns){this.addToDns(item);}} return (A) this;
    }

    public A withDns(String... Dns){
            this.Dns.clear(); if (Dns != null) {for (String item :Dns){ this.addToDns(item);}} return (A) this;
    }

    public A addToDnsOptions(String... items){
            for (String item : items) {this.DnsOptions.add(item);} return (A)this;
    }

    public A removeFromDnsOptions(String... items){
            for (String item : items) {this.DnsOptions.remove(item);} return (A)this;
    }

    public List<String> getDnsOptions(){
            return this.DnsOptions;
    }

    public A withDnsOptions(List<String> DnsOptions){
            this.DnsOptions.clear();
            if (DnsOptions != null) {for (String item : DnsOptions){this.addToDnsOptions(item);}} return (A) this;
    }

    public A withDnsOptions(String... DnsOptions){
            this.DnsOptions.clear(); if (DnsOptions != null) {for (String item :DnsOptions){ this.addToDnsOptions(item);}} return (A) this;
    }

    public A addToDnsSearch(String... items){
            for (String item : items) {this.DnsSearch.add(item);} return (A)this;
    }

    public A removeFromDnsSearch(String... items){
            for (String item : items) {this.DnsSearch.remove(item);} return (A)this;
    }

    public List<String> getDnsSearch(){
            return this.DnsSearch;
    }

    public A withDnsSearch(List<String> DnsSearch){
            this.DnsSearch.clear();
            if (DnsSearch != null) {for (String item : DnsSearch){this.addToDnsSearch(item);}} return (A) this;
    }

    public A withDnsSearch(String... DnsSearch){
            this.DnsSearch.clear(); if (DnsSearch != null) {for (String item :DnsSearch){ this.addToDnsSearch(item);}} return (A) this;
    }

    public A addToExtraHosts(String... items){
            for (String item : items) {this.ExtraHosts.add(item);} return (A)this;
    }

    public A removeFromExtraHosts(String... items){
            for (String item : items) {this.ExtraHosts.remove(item);} return (A)this;
    }

    public List<String> getExtraHosts(){
            return this.ExtraHosts;
    }

    public A withExtraHosts(List<String> ExtraHosts){
            this.ExtraHosts.clear();
            if (ExtraHosts != null) {for (String item : ExtraHosts){this.addToExtraHosts(item);}} return (A) this;
    }

    public A withExtraHosts(String... ExtraHosts){
            this.ExtraHosts.clear(); if (ExtraHosts != null) {for (String item :ExtraHosts){ this.addToExtraHosts(item);}} return (A) this;
    }

    public A addToGroupAdd(String... items){
            for (String item : items) {this.GroupAdd.add(item);} return (A)this;
    }

    public A removeFromGroupAdd(String... items){
            for (String item : items) {this.GroupAdd.remove(item);} return (A)this;
    }

    public List<String> getGroupAdd(){
            return this.GroupAdd;
    }

    public A withGroupAdd(List<String> GroupAdd){
            this.GroupAdd.clear();
            if (GroupAdd != null) {for (String item : GroupAdd){this.addToGroupAdd(item);}} return (A) this;
    }

    public A withGroupAdd(String... GroupAdd){
            this.GroupAdd.clear(); if (GroupAdd != null) {for (String item :GroupAdd){ this.addToGroupAdd(item);}} return (A) this;
    }

    public String getIpcMode(){
            return this.IpcMode;
    }

    public A withIpcMode(String IpcMode){
            this.IpcMode=IpcMode; return (A) this;
    }

    public Long getKernelMemory(){
            return this.KernelMemory;
    }

    public A withKernelMemory(Long KernelMemory){
            this.KernelMemory=KernelMemory; return (A) this;
    }

    public A addToLinks(String... items){
            for (String item : items) {this.Links.add(item);} return (A)this;
    }

    public A removeFromLinks(String... items){
            for (String item : items) {this.Links.remove(item);} return (A)this;
    }

    public List<String> getLinks(){
            return this.Links;
    }

    public A withLinks(List<String> Links){
            this.Links.clear();
            if (Links != null) {for (String item : Links){this.addToLinks(item);}} return (A) this;
    }

    public A withLinks(String... Links){
            this.Links.clear(); if (Links != null) {for (String item :Links){ this.addToLinks(item);}} return (A) this;
    }

    public LogConfig getLogConfig(){
            return this.LogConfig!=null?this.LogConfig.build():null;
    }

    public A withLogConfig(LogConfig LogConfig){
            _visitables.remove(this.LogConfig);
            if (LogConfig!=null){ this.LogConfig= new LogConfigBuilder(LogConfig); _visitables.add(this.LogConfig);} return (A) this;
    }

    public HostConfigFluent.LogConfigNested<A> withNewLogConfig(){
            return new LogConfigNestedImpl();
    }

    public HostConfigFluent.LogConfigNested<A> withNewLogConfigLike(LogConfig item){
            return new LogConfigNestedImpl(item);
    }

    public HostConfigFluent.LogConfigNested<A> editLogConfig(){
            return withNewLogConfigLike(getLogConfig());
    }

    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfig(){
            return withNewLogConfigLike(getLogConfig() != null ? getLogConfig(): new LogConfigBuilder().build());
    }

    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfigLike(LogConfig item){
            return withNewLogConfigLike(getLogConfig() != null ? getLogConfig(): item);
    }

    public LxcConfig getLxcConf(){
            return this.LxcConf;
    }

    public A withLxcConf(LxcConfig LxcConf){
            this.LxcConf=LxcConf; return (A) this;
    }

    public Long getMemory(){
            return this.Memory;
    }

    public A withMemory(Long Memory){
            this.Memory=Memory; return (A) this;
    }

    public Long getMemoryReservation(){
            return this.MemoryReservation;
    }

    public A withMemoryReservation(Long MemoryReservation){
            this.MemoryReservation=MemoryReservation; return (A) this;
    }

    public Long getMemorySwap(){
            return this.MemorySwap;
    }

    public A withMemorySwap(Long MemorySwap){
            this.MemorySwap=MemorySwap; return (A) this;
    }

    public Long getMemorySwappiness(){
            return this.MemorySwappiness;
    }

    public A withMemorySwappiness(Long MemorySwappiness){
            this.MemorySwappiness=MemorySwappiness; return (A) this;
    }

    public String getNetworkMode(){
            return this.NetworkMode;
    }

    public A withNetworkMode(String NetworkMode){
            this.NetworkMode=NetworkMode; return (A) this;
    }

    public Boolean isOomKillDisable(){
            return this.OomKillDisable;
    }

    public A withOomKillDisable(Boolean OomKillDisable){
            this.OomKillDisable=OomKillDisable; return (A) this;
    }

    public String getPidMode(){
            return this.PidMode;
    }

    public A withPidMode(String PidMode){
            this.PidMode=PidMode; return (A) this;
    }

    public A addToPortBindings(String key,ArrayList<PortBinding> value){
            if(key != null && value != null) {this.PortBindings.put(key, value);} return (A)this;
    }

    public A addToPortBindings(Map<String,ArrayList<PortBinding>> map){
            if(map != null) { this.PortBindings.putAll(map);} return (A)this;
    }

    public A removeFromPortBindings(String key){
            if(key != null) {this.PortBindings.remove(key);} return (A)this;
    }

    public A removeFromPortBindings(Map<String,ArrayList<PortBinding>> map){
            if(map != null) { for(Object key : map.keySet()) {this.PortBindings.remove(key);}} return (A)this;
    }

    public Map<String,ArrayList<PortBinding>> getPortBindings(){
            return this.PortBindings;
    }

    public A withPortBindings(Map<String,ArrayList<PortBinding>> PortBindings){
            this.PortBindings.clear();
            if (PortBindings != null) {this.PortBindings.putAll(PortBindings);} return (A) this;
    }

    public Boolean isPrivileged(){
            return this.Privileged;
    }

    public A withPrivileged(Boolean Privileged){
            this.Privileged=Privileged; return (A) this;
    }

    public Boolean isPublishAllPorts(){
            return this.PublishAllPorts;
    }

    public A withPublishAllPorts(Boolean PublishAllPorts){
            this.PublishAllPorts=PublishAllPorts; return (A) this;
    }

    public Boolean isReadonlyRootfs(){
            return this.ReadonlyRootfs;
    }

    public A withReadonlyRootfs(Boolean ReadonlyRootfs){
            this.ReadonlyRootfs=ReadonlyRootfs; return (A) this;
    }

    public RestartPolicy getRestartPolicy(){
            return this.RestartPolicy!=null?this.RestartPolicy.build():null;
    }

    public A withRestartPolicy(RestartPolicy RestartPolicy){
            _visitables.remove(this.RestartPolicy);
            if (RestartPolicy!=null){ this.RestartPolicy= new RestartPolicyBuilder(RestartPolicy); _visitables.add(this.RestartPolicy);} return (A) this;
    }

    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicy(){
            return new RestartPolicyNestedImpl();
    }

    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicyLike(RestartPolicy item){
            return new RestartPolicyNestedImpl(item);
    }

    public HostConfigFluent.RestartPolicyNested<A> editRestartPolicy(){
            return withNewRestartPolicyLike(getRestartPolicy());
    }

    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicy(){
            return withNewRestartPolicyLike(getRestartPolicy() != null ? getRestartPolicy(): new RestartPolicyBuilder().build());
    }

    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicyLike(RestartPolicy item){
            return withNewRestartPolicyLike(getRestartPolicy() != null ? getRestartPolicy(): item);
    }

    public A withNewRestartPolicy(Integer MaximumRetryCount,String Name){
            return (A)withRestartPolicy(new RestartPolicy(MaximumRetryCount, Name));
    }

    public A addToSecurityOpt(String... items){
            for (String item : items) {this.SecurityOpt.add(item);} return (A)this;
    }

    public A removeFromSecurityOpt(String... items){
            for (String item : items) {this.SecurityOpt.remove(item);} return (A)this;
    }

    public List<String> getSecurityOpt(){
            return this.SecurityOpt;
    }

    public A withSecurityOpt(List<String> SecurityOpt){
            this.SecurityOpt.clear();
            if (SecurityOpt != null) {for (String item : SecurityOpt){this.addToSecurityOpt(item);}} return (A) this;
    }

    public A withSecurityOpt(String... SecurityOpt){
            this.SecurityOpt.clear(); if (SecurityOpt != null) {for (String item :SecurityOpt){ this.addToSecurityOpt(item);}} return (A) this;
    }

    public String getUTSMode(){
            return this.UTSMode;
    }

    public A withUTSMode(String UTSMode){
            this.UTSMode=UTSMode; return (A) this;
    }

    public A addToUlimits(Ulimit... items){
            for (Ulimit item : items) {UlimitBuilder builder = new UlimitBuilder(item);_visitables.add(builder);this.Ulimits.add(builder);} return (A)this;
    }

    public A removeFromUlimits(Ulimit... items){
            for (Ulimit item : items) {UlimitBuilder builder = new UlimitBuilder(item);_visitables.remove(builder);this.Ulimits.remove(builder);} return (A)this;
    }

    public List<Ulimit> getUlimits(){
            return build(Ulimits);
    }

    public A withUlimits(List<Ulimit> Ulimits){
            _visitables.removeAll(this.Ulimits);
            this.Ulimits.clear();
            if (Ulimits != null) {for (Ulimit item : Ulimits){this.addToUlimits(item);}} return (A) this;
    }

    public A withUlimits(Ulimit... Ulimits){
            this.Ulimits.clear(); if (Ulimits != null) {for (Ulimit item :Ulimits){ this.addToUlimits(item);}} return (A) this;
    }

    public HostConfigFluent.UlimitsNested<A> addNewUlimit(){
            return new UlimitsNestedImpl();
    }

    public HostConfigFluent.UlimitsNested<A> addNewUlimitLike(Ulimit item){
            return new UlimitsNestedImpl(item);
    }

    public A addNewUlimit(Long Hard,String Name,Long Soft){
            return (A)addToUlimits(new Ulimit(Hard, Name, Soft));
    }

    public String getVolumeDriver(){
            return this.VolumeDriver;
    }

    public A withVolumeDriver(String VolumeDriver){
            this.VolumeDriver=VolumeDriver; return (A) this;
    }

    public A addToVolumesFrom(String... items){
            for (String item : items) {this.VolumesFrom.add(item);} return (A)this;
    }

    public A removeFromVolumesFrom(String... items){
            for (String item : items) {this.VolumesFrom.remove(item);} return (A)this;
    }

    public List<String> getVolumesFrom(){
            return this.VolumesFrom;
    }

    public A withVolumesFrom(List<String> VolumesFrom){
            this.VolumesFrom.clear();
            if (VolumesFrom != null) {for (String item : VolumesFrom){this.addToVolumesFrom(item);}} return (A) this;
    }

    public A withVolumesFrom(String... VolumesFrom){
            this.VolumesFrom.clear(); if (VolumesFrom != null) {for (String item :VolumesFrom){ this.addToVolumesFrom(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HostConfigFluentImpl that = (HostConfigFluentImpl) o;
            if (Binds != null ? !Binds.equals(that.Binds) :that.Binds != null) return false;
            if (BlkioWeight != null ? !BlkioWeight.equals(that.BlkioWeight) :that.BlkioWeight != null) return false;
            if (CapAdd != null ? !CapAdd.equals(that.CapAdd) :that.CapAdd != null) return false;
            if (CapDrop != null ? !CapDrop.equals(that.CapDrop) :that.CapDrop != null) return false;
            if (CgroupParent != null ? !CgroupParent.equals(that.CgroupParent) :that.CgroupParent != null) return false;
            if (ConsoleSize != null &&ConsoleSize != this ? !ConsoleSize.equals(that.ConsoleSize) :that.ConsoleSize != null &&ConsoleSize != this ) return false;

            if (ContainerIDFile != null ? !ContainerIDFile.equals(that.ContainerIDFile) :that.ContainerIDFile != null) return false;
            if (CpuPeriod != null ? !CpuPeriod.equals(that.CpuPeriod) :that.CpuPeriod != null) return false;
            if (CpuQuota != null ? !CpuQuota.equals(that.CpuQuota) :that.CpuQuota != null) return false;
            if (CpuShares != null ? !CpuShares.equals(that.CpuShares) :that.CpuShares != null) return false;
            if (CpusetCpus != null ? !CpusetCpus.equals(that.CpusetCpus) :that.CpusetCpus != null) return false;
            if (CpusetMems != null ? !CpusetMems.equals(that.CpusetMems) :that.CpusetMems != null) return false;
            if (Devices != null ? !Devices.equals(that.Devices) :that.Devices != null) return false;
            if (Dns != null ? !Dns.equals(that.Dns) :that.Dns != null) return false;
            if (DnsOptions != null ? !DnsOptions.equals(that.DnsOptions) :that.DnsOptions != null) return false;
            if (DnsSearch != null ? !DnsSearch.equals(that.DnsSearch) :that.DnsSearch != null) return false;
            if (ExtraHosts != null ? !ExtraHosts.equals(that.ExtraHosts) :that.ExtraHosts != null) return false;
            if (GroupAdd != null ? !GroupAdd.equals(that.GroupAdd) :that.GroupAdd != null) return false;
            if (IpcMode != null ? !IpcMode.equals(that.IpcMode) :that.IpcMode != null) return false;
            if (KernelMemory != null ? !KernelMemory.equals(that.KernelMemory) :that.KernelMemory != null) return false;
            if (Links != null ? !Links.equals(that.Links) :that.Links != null) return false;
            if (LogConfig != null ? !LogConfig.equals(that.LogConfig) :that.LogConfig != null) return false;
            if (LxcConf != null ? !LxcConf.equals(that.LxcConf) :that.LxcConf != null) return false;
            if (Memory != null ? !Memory.equals(that.Memory) :that.Memory != null) return false;
            if (MemoryReservation != null ? !MemoryReservation.equals(that.MemoryReservation) :that.MemoryReservation != null) return false;
            if (MemorySwap != null ? !MemorySwap.equals(that.MemorySwap) :that.MemorySwap != null) return false;
            if (MemorySwappiness != null ? !MemorySwappiness.equals(that.MemorySwappiness) :that.MemorySwappiness != null) return false;
            if (NetworkMode != null ? !NetworkMode.equals(that.NetworkMode) :that.NetworkMode != null) return false;
            if (OomKillDisable != null ? !OomKillDisable.equals(that.OomKillDisable) :that.OomKillDisable != null) return false;
            if (PidMode != null ? !PidMode.equals(that.PidMode) :that.PidMode != null) return false;
            if (PortBindings != null ? !PortBindings.equals(that.PortBindings) :that.PortBindings != null) return false;
            if (Privileged != null ? !Privileged.equals(that.Privileged) :that.Privileged != null) return false;
            if (PublishAllPorts != null ? !PublishAllPorts.equals(that.PublishAllPorts) :that.PublishAllPorts != null) return false;
            if (ReadonlyRootfs != null ? !ReadonlyRootfs.equals(that.ReadonlyRootfs) :that.ReadonlyRootfs != null) return false;
            if (RestartPolicy != null ? !RestartPolicy.equals(that.RestartPolicy) :that.RestartPolicy != null) return false;
            if (SecurityOpt != null ? !SecurityOpt.equals(that.SecurityOpt) :that.SecurityOpt != null) return false;
            if (UTSMode != null ? !UTSMode.equals(that.UTSMode) :that.UTSMode != null) return false;
            if (Ulimits != null ? !Ulimits.equals(that.Ulimits) :that.Ulimits != null) return false;
            if (VolumeDriver != null ? !VolumeDriver.equals(that.VolumeDriver) :that.VolumeDriver != null) return false;
            if (VolumesFrom != null ? !VolumesFrom.equals(that.VolumesFrom) :that.VolumesFrom != null) return false;
            return true;
    }


    public class DevicesNestedImpl<N> extends DeviceMappingFluentImpl<HostConfigFluent.DevicesNested<N>> implements HostConfigFluent.DevicesNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final DeviceMappingBuilder builder;
    
            DevicesNestedImpl(DeviceMapping item){
                    this.builder = new DeviceMappingBuilder(this, item);
            }
            DevicesNestedImpl(){
                    this.builder = new DeviceMappingBuilder(this);
            }
    
    public N and(){
            return (N) HostConfigFluentImpl.this.addToDevices(builder.build());
    }
    public N endDevice(){
            return and();
    }

}
    public class LogConfigNestedImpl<N> extends LogConfigFluentImpl<HostConfigFluent.LogConfigNested<N>> implements HostConfigFluent.LogConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final LogConfigBuilder builder;
    
            LogConfigNestedImpl(LogConfig item){
                    this.builder = new LogConfigBuilder(this, item);
            }
            LogConfigNestedImpl(){
                    this.builder = new LogConfigBuilder(this);
            }
    
    public N and(){
            return (N) HostConfigFluentImpl.this.withLogConfig(builder.build());
    }
    public N endLogConfig(){
            return and();
    }

}
    public class RestartPolicyNestedImpl<N> extends RestartPolicyFluentImpl<HostConfigFluent.RestartPolicyNested<N>> implements HostConfigFluent.RestartPolicyNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final RestartPolicyBuilder builder;
    
            RestartPolicyNestedImpl(RestartPolicy item){
                    this.builder = new RestartPolicyBuilder(this, item);
            }
            RestartPolicyNestedImpl(){
                    this.builder = new RestartPolicyBuilder(this);
            }
    
    public N and(){
            return (N) HostConfigFluentImpl.this.withRestartPolicy(builder.build());
    }
    public N endRestartPolicy(){
            return and();
    }

}
    public class UlimitsNestedImpl<N> extends UlimitFluentImpl<HostConfigFluent.UlimitsNested<N>> implements HostConfigFluent.UlimitsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final UlimitBuilder builder;
    
            UlimitsNestedImpl(Ulimit item){
                    this.builder = new UlimitBuilder(this, item);
            }
            UlimitsNestedImpl(){
                    this.builder = new UlimitBuilder(this);
            }
    
    public N and(){
            return (N) HostConfigFluentImpl.this.addToUlimits(builder.build());
    }
    public N endUlimit(){
            return and();
    }

}


}
