package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.docker.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface HostConfigFluent<A extends HostConfigFluent<A>> extends Fluent<A>{


    public A addToBinds(String... items);
    public A removeFromBinds(String... items);
    public List<String> getBinds();
    public A withBinds(List<String> Binds);
    public A withBinds(String... Binds);
    public Integer getBlkioWeight();
    public A withBlkioWeight(Integer BlkioWeight);
    public A addToCapAdd(String... items);
    public A removeFromCapAdd(String... items);
    public List<String> getCapAdd();
    public A withCapAdd(List<String> CapAdd);
    public A withCapAdd(String... CapAdd);
    public A addToCapDrop(String... items);
    public A removeFromCapDrop(String... items);
    public List<String> getCapDrop();
    public A withCapDrop(List<String> CapDrop);
    public A withCapDrop(String... CapDrop);
    public String getCgroupParent();
    public A withCgroupParent(String CgroupParent);
    public Object getConsoleSize();
    public A withConsoleSize(Object ConsoleSize);
    public String getContainerIDFile();
    public A withContainerIDFile(String ContainerIDFile);
    public Long getCpuPeriod();
    public A withCpuPeriod(Long CpuPeriod);
    public Long getCpuQuota();
    public A withCpuQuota(Long CpuQuota);
    public Long getCpuShares();
    public A withCpuShares(Long CpuShares);
    public String getCpusetCpus();
    public A withCpusetCpus(String CpusetCpus);
    public String getCpusetMems();
    public A withCpusetMems(String CpusetMems);
    public A addToDevices(DeviceMapping... items);
    public A removeFromDevices(DeviceMapping... items);
    public List<DeviceMapping> getDevices();
    public A withDevices(List<DeviceMapping> Devices);
    public A withDevices(DeviceMapping... Devices);
    public HostConfigFluent.DevicesNested<A> addNewDevice();
    public HostConfigFluent.DevicesNested<A> addNewDeviceLike(DeviceMapping item);
    public A addNewDevice(String CgroupPermissions,String PathInContainer,String PathOnHost);
    public A addToDns(String... items);
    public A removeFromDns(String... items);
    public List<String> getDns();
    public A withDns(List<String> Dns);
    public A withDns(String... Dns);
    public A addToDnsOptions(String... items);
    public A removeFromDnsOptions(String... items);
    public List<String> getDnsOptions();
    public A withDnsOptions(List<String> DnsOptions);
    public A withDnsOptions(String... DnsOptions);
    public A addToDnsSearch(String... items);
    public A removeFromDnsSearch(String... items);
    public List<String> getDnsSearch();
    public A withDnsSearch(List<String> DnsSearch);
    public A withDnsSearch(String... DnsSearch);
    public A addToExtraHosts(String... items);
    public A removeFromExtraHosts(String... items);
    public List<String> getExtraHosts();
    public A withExtraHosts(List<String> ExtraHosts);
    public A withExtraHosts(String... ExtraHosts);
    public A addToGroupAdd(String... items);
    public A removeFromGroupAdd(String... items);
    public List<String> getGroupAdd();
    public A withGroupAdd(List<String> GroupAdd);
    public A withGroupAdd(String... GroupAdd);
    public String getIpcMode();
    public A withIpcMode(String IpcMode);
    public Long getKernelMemory();
    public A withKernelMemory(Long KernelMemory);
    public A addToLinks(String... items);
    public A removeFromLinks(String... items);
    public List<String> getLinks();
    public A withLinks(List<String> Links);
    public A withLinks(String... Links);
    public LogConfig getLogConfig();
    public A withLogConfig(LogConfig LogConfig);
    public HostConfigFluent.LogConfigNested<A> withNewLogConfig();
    public HostConfigFluent.LogConfigNested<A> withNewLogConfigLike(LogConfig item);
    public HostConfigFluent.LogConfigNested<A> editLogConfig();
    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfig();
    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfigLike(LogConfig item);
    public LxcConfig getLxcConf();
    public A withLxcConf(LxcConfig LxcConf);
    public Long getMemory();
    public A withMemory(Long Memory);
    public Long getMemoryReservation();
    public A withMemoryReservation(Long MemoryReservation);
    public Long getMemorySwap();
    public A withMemorySwap(Long MemorySwap);
    public Long getMemorySwappiness();
    public A withMemorySwappiness(Long MemorySwappiness);
    public String getNetworkMode();
    public A withNetworkMode(String NetworkMode);
    public Boolean isOomKillDisable();
    public A withOomKillDisable(Boolean OomKillDisable);
    public String getPidMode();
    public A withPidMode(String PidMode);
    public A addToPortBindings(String key,ArrayList<PortBinding> value);
    public A addToPortBindings(Map<String,ArrayList<PortBinding>> map);
    public A removeFromPortBindings(String key);
    public A removeFromPortBindings(Map<String,ArrayList<PortBinding>> map);
    public Map<String,ArrayList<PortBinding>> getPortBindings();
    public A withPortBindings(Map<String,ArrayList<PortBinding>> PortBindings);
    public Boolean isPrivileged();
    public A withPrivileged(Boolean Privileged);
    public Boolean isPublishAllPorts();
    public A withPublishAllPorts(Boolean PublishAllPorts);
    public Boolean isReadonlyRootfs();
    public A withReadonlyRootfs(Boolean ReadonlyRootfs);
    public RestartPolicy getRestartPolicy();
    public A withRestartPolicy(RestartPolicy RestartPolicy);
    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicy();
    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicyLike(RestartPolicy item);
    public HostConfigFluent.RestartPolicyNested<A> editRestartPolicy();
    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicy();
    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicyLike(RestartPolicy item);
    public A withNewRestartPolicy(Integer MaximumRetryCount,String Name);
    public A addToSecurityOpt(String... items);
    public A removeFromSecurityOpt(String... items);
    public List<String> getSecurityOpt();
    public A withSecurityOpt(List<String> SecurityOpt);
    public A withSecurityOpt(String... SecurityOpt);
    public String getUTSMode();
    public A withUTSMode(String UTSMode);
    public A addToUlimits(Ulimit... items);
    public A removeFromUlimits(Ulimit... items);
    public List<Ulimit> getUlimits();
    public A withUlimits(List<Ulimit> Ulimits);
    public A withUlimits(Ulimit... Ulimits);
    public HostConfigFluent.UlimitsNested<A> addNewUlimit();
    public HostConfigFluent.UlimitsNested<A> addNewUlimitLike(Ulimit item);
    public A addNewUlimit(Long Hard,String Name,Long Soft);
    public String getVolumeDriver();
    public A withVolumeDriver(String VolumeDriver);
    public A addToVolumesFrom(String... items);
    public A removeFromVolumesFrom(String... items);
    public List<String> getVolumesFrom();
    public A withVolumesFrom(List<String> VolumesFrom);
    public A withVolumesFrom(String... VolumesFrom);

    public interface DevicesNested<N> extends io.fabric8.docker.api.builder.Nested<N>,DeviceMappingFluent<HostConfigFluent.DevicesNested<N>>{

        
    public N and();    public N endDevice();
}
    public interface LogConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,LogConfigFluent<HostConfigFluent.LogConfigNested<N>>{

        
    public N and();    public N endLogConfig();
}
    public interface RestartPolicyNested<N> extends io.fabric8.docker.api.builder.Nested<N>,RestartPolicyFluent<HostConfigFluent.RestartPolicyNested<N>>{

        
    public N and();    public N endRestartPolicy();
}
    public interface UlimitsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,UlimitFluent<HostConfigFluent.UlimitsNested<N>>{

        
    public N and();    public N endUlimit();
}


}
