package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class HostConfigBuilder extends HostConfigFluentImpl<HostConfigBuilder> implements VisitableBuilder<HostConfig,HostConfigBuilder>{

    HostConfigFluent<?> fluent;
    Boolean validationEnabled;

    public HostConfigBuilder(){
            this(true);
    }
    public HostConfigBuilder(Boolean validationEnabled){
            this(new HostConfig(), validationEnabled);
    }
    public HostConfigBuilder(HostConfigFluent<?> fluent){
            this(fluent, true);
    }
    public HostConfigBuilder(HostConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HostConfig(), validationEnabled);
    }
    public HostConfigBuilder(HostConfigFluent<?> fluent,HostConfig instance){
            this(fluent, instance, true);
    }
    public HostConfigBuilder(HostConfigFluent<?> fluent,HostConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBinds(instance.getBinds()); 
            fluent.withBlkioWeight(instance.getBlkioWeight()); 
            fluent.withCapAdd(instance.getCapAdd()); 
            fluent.withCapDrop(instance.getCapDrop()); 
            fluent.withCgroupParent(instance.getCgroupParent()); 
            fluent.withConsoleSize(instance.getConsoleSize()); 
            fluent.withContainerIDFile(instance.getContainerIDFile()); 
            fluent.withCpuPeriod(instance.getCpuPeriod()); 
            fluent.withCpuQuota(instance.getCpuQuota()); 
            fluent.withCpuShares(instance.getCpuShares()); 
            fluent.withCpusetCpus(instance.getCpusetCpus()); 
            fluent.withCpusetMems(instance.getCpusetMems()); 
            fluent.withDevices(instance.getDevices()); 
            fluent.withDns(instance.getDns()); 
            fluent.withDnsOptions(instance.getDnsOptions()); 
            fluent.withDnsSearch(instance.getDnsSearch()); 
            fluent.withExtraHosts(instance.getExtraHosts()); 
            fluent.withGroupAdd(instance.getGroupAdd()); 
            fluent.withIpcMode(instance.getIpcMode()); 
            fluent.withKernelMemory(instance.getKernelMemory()); 
            fluent.withLinks(instance.getLinks()); 
            fluent.withLogConfig(instance.getLogConfig()); 
            fluent.withLxcConf(instance.getLxcConf()); 
            fluent.withMemory(instance.getMemory()); 
            fluent.withMemoryReservation(instance.getMemoryReservation()); 
            fluent.withMemorySwap(instance.getMemorySwap()); 
            fluent.withMemorySwappiness(instance.getMemorySwappiness()); 
            fluent.withNetworkMode(instance.getNetworkMode()); 
            fluent.withOomKillDisable(instance.getOomKillDisable()); 
            fluent.withPidMode(instance.getPidMode()); 
            fluent.withPortBindings(instance.getPortBindings()); 
            fluent.withPrivileged(instance.getPrivileged()); 
            fluent.withPublishAllPorts(instance.getPublishAllPorts()); 
            fluent.withReadonlyRootfs(instance.getReadonlyRootfs()); 
            fluent.withRestartPolicy(instance.getRestartPolicy()); 
            fluent.withSecurityOpt(instance.getSecurityOpt()); 
            fluent.withUTSMode(instance.getUTSMode()); 
            fluent.withUlimits(instance.getUlimits()); 
            fluent.withVolumeDriver(instance.getVolumeDriver()); 
            fluent.withVolumesFrom(instance.getVolumesFrom()); 
            this.validationEnabled = validationEnabled; 
    }
    public HostConfigBuilder(HostConfig instance){
            this(instance,true);
    }
    public HostConfigBuilder(HostConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBinds(instance.getBinds()); 
            this.withBlkioWeight(instance.getBlkioWeight()); 
            this.withCapAdd(instance.getCapAdd()); 
            this.withCapDrop(instance.getCapDrop()); 
            this.withCgroupParent(instance.getCgroupParent()); 
            this.withConsoleSize(instance.getConsoleSize()); 
            this.withContainerIDFile(instance.getContainerIDFile()); 
            this.withCpuPeriod(instance.getCpuPeriod()); 
            this.withCpuQuota(instance.getCpuQuota()); 
            this.withCpuShares(instance.getCpuShares()); 
            this.withCpusetCpus(instance.getCpusetCpus()); 
            this.withCpusetMems(instance.getCpusetMems()); 
            this.withDevices(instance.getDevices()); 
            this.withDns(instance.getDns()); 
            this.withDnsOptions(instance.getDnsOptions()); 
            this.withDnsSearch(instance.getDnsSearch()); 
            this.withExtraHosts(instance.getExtraHosts()); 
            this.withGroupAdd(instance.getGroupAdd()); 
            this.withIpcMode(instance.getIpcMode()); 
            this.withKernelMemory(instance.getKernelMemory()); 
            this.withLinks(instance.getLinks()); 
            this.withLogConfig(instance.getLogConfig()); 
            this.withLxcConf(instance.getLxcConf()); 
            this.withMemory(instance.getMemory()); 
            this.withMemoryReservation(instance.getMemoryReservation()); 
            this.withMemorySwap(instance.getMemorySwap()); 
            this.withMemorySwappiness(instance.getMemorySwappiness()); 
            this.withNetworkMode(instance.getNetworkMode()); 
            this.withOomKillDisable(instance.getOomKillDisable()); 
            this.withPidMode(instance.getPidMode()); 
            this.withPortBindings(instance.getPortBindings()); 
            this.withPrivileged(instance.getPrivileged()); 
            this.withPublishAllPorts(instance.getPublishAllPorts()); 
            this.withReadonlyRootfs(instance.getReadonlyRootfs()); 
            this.withRestartPolicy(instance.getRestartPolicy()); 
            this.withSecurityOpt(instance.getSecurityOpt()); 
            this.withUTSMode(instance.getUTSMode()); 
            this.withUlimits(instance.getUlimits()); 
            this.withVolumeDriver(instance.getVolumeDriver()); 
            this.withVolumesFrom(instance.getVolumesFrom()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableHostConfig build(){
            EditableHostConfig buildable = new EditableHostConfig(fluent.getBinds(),fluent.getBlkioWeight(),fluent.getCapAdd(),fluent.getCapDrop(),fluent.getCgroupParent(),fluent.getConsoleSize(),fluent.getContainerIDFile(),fluent.getCpuPeriod(),fluent.getCpuQuota(),fluent.getCpuShares(),fluent.getCpusetCpus(),fluent.getCpusetMems(),fluent.getDevices(),fluent.getDns(),fluent.getDnsOptions(),fluent.getDnsSearch(),fluent.getExtraHosts(),fluent.getGroupAdd(),fluent.getIpcMode(),fluent.getKernelMemory(),fluent.getLinks(),fluent.getLogConfig(),fluent.getLxcConf(),fluent.getMemory(),fluent.getMemoryReservation(),fluent.getMemorySwap(),fluent.getMemorySwappiness(),fluent.getNetworkMode(),fluent.isOomKillDisable(),fluent.getPidMode(),fluent.getPortBindings(),fluent.isPrivileged(),fluent.isPublishAllPorts(),fluent.isReadonlyRootfs(),fluent.getRestartPolicy(),fluent.getSecurityOpt(),fluent.getUTSMode(),fluent.getUlimits(),fluent.getVolumeDriver(),fluent.getVolumesFrom());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HostConfigBuilder that = (HostConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
