package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class GraphDriverDataBuilder extends GraphDriverDataFluentImpl<GraphDriverDataBuilder> implements VisitableBuilder<GraphDriverData,GraphDriverDataBuilder>{

    GraphDriverDataFluent<?> fluent;
    Boolean validationEnabled;

    public GraphDriverDataBuilder(){
            this(true);
    }
    public GraphDriverDataBuilder(Boolean validationEnabled){
            this(new GraphDriverData(), validationEnabled);
    }
    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent){
            this(fluent, true);
    }
    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GraphDriverData(), validationEnabled);
    }
    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent,GraphDriverData instance){
            this(fluent, instance, true);
    }
    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent,GraphDriverData instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withData(instance.getData()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public GraphDriverDataBuilder(GraphDriverData instance){
            this(instance,true);
    }
    public GraphDriverDataBuilder(GraphDriverData instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withData(instance.getData()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableGraphDriverData build(){
            EditableGraphDriverData buildable = new EditableGraphDriverData(fluent.getData(),fluent.getName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GraphDriverDataBuilder that = (GraphDriverDataBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
