package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ExecConfigFluentImpl<A extends ExecConfigFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ExecConfigFluent<A>{

    private Boolean AttachStderr;
    private Boolean AttachStdin;
    private Boolean AttachStdout;
    private List<String> Cmd = new ArrayList<String>();
    private String Container;
    private Boolean Detach;
    private Boolean Privileged;
    private Boolean Tty;
    private String User;

    public ExecConfigFluentImpl(){
    }
    public ExecConfigFluentImpl(ExecConfig instance){
            this.withAttachStderr(instance.getAttachStderr()); 
            this.withAttachStdin(instance.getAttachStdin()); 
            this.withAttachStdout(instance.getAttachStdout()); 
            this.withCmd(instance.getCmd()); 
            this.withContainer(instance.getContainer()); 
            this.withDetach(instance.getDetach()); 
            this.withPrivileged(instance.getPrivileged()); 
            this.withTty(instance.getTty()); 
            this.withUser(instance.getUser()); 
    }

    public Boolean isAttachStderr(){
            return this.AttachStderr;
    }

    public A withAttachStderr(Boolean AttachStderr){
            this.AttachStderr=AttachStderr; return (A) this;
    }

    public Boolean isAttachStdin(){
            return this.AttachStdin;
    }

    public A withAttachStdin(Boolean AttachStdin){
            this.AttachStdin=AttachStdin; return (A) this;
    }

    public Boolean isAttachStdout(){
            return this.AttachStdout;
    }

    public A withAttachStdout(Boolean AttachStdout){
            this.AttachStdout=AttachStdout; return (A) this;
    }

    public A addToCmd(String... items){
            for (String item : items) {this.Cmd.add(item);} return (A)this;
    }

    public A removeFromCmd(String... items){
            for (String item : items) {this.Cmd.remove(item);} return (A)this;
    }

    public List<String> getCmd(){
            return this.Cmd;
    }

    public A withCmd(List<String> Cmd){
            this.Cmd.clear();
            if (Cmd != null) {for (String item : Cmd){this.addToCmd(item);}} return (A) this;
    }

    public A withCmd(String... Cmd){
            this.Cmd.clear(); if (Cmd != null) {for (String item :Cmd){ this.addToCmd(item);}} return (A) this;
    }

    public String getContainer(){
            return this.Container;
    }

    public A withContainer(String Container){
            this.Container=Container; return (A) this;
    }

    public Boolean isDetach(){
            return this.Detach;
    }

    public A withDetach(Boolean Detach){
            this.Detach=Detach; return (A) this;
    }

    public Boolean isPrivileged(){
            return this.Privileged;
    }

    public A withPrivileged(Boolean Privileged){
            this.Privileged=Privileged; return (A) this;
    }

    public Boolean isTty(){
            return this.Tty;
    }

    public A withTty(Boolean Tty){
            this.Tty=Tty; return (A) this;
    }

    public String getUser(){
            return this.User;
    }

    public A withUser(String User){
            this.User=User; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExecConfigFluentImpl that = (ExecConfigFluentImpl) o;
            if (AttachStderr != null ? !AttachStderr.equals(that.AttachStderr) :that.AttachStderr != null) return false;
            if (AttachStdin != null ? !AttachStdin.equals(that.AttachStdin) :that.AttachStdin != null) return false;
            if (AttachStdout != null ? !AttachStdout.equals(that.AttachStdout) :that.AttachStdout != null) return false;
            if (Cmd != null ? !Cmd.equals(that.Cmd) :that.Cmd != null) return false;
            if (Container != null ? !Container.equals(that.Container) :that.Container != null) return false;
            if (Detach != null ? !Detach.equals(that.Detach) :that.Detach != null) return false;
            if (Privileged != null ? !Privileged.equals(that.Privileged) :that.Privileged != null) return false;
            if (Tty != null ? !Tty.equals(that.Tty) :that.Tty != null) return false;
            if (User != null ? !User.equals(that.User) :that.User != null) return false;
            return true;
    }




}
