package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ExecConfigBuilder extends ExecConfigFluentImpl<ExecConfigBuilder> implements VisitableBuilder<ExecConfig,ExecConfigBuilder>{

    ExecConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ExecConfigBuilder(){
            this(true);
    }
    public ExecConfigBuilder(Boolean validationEnabled){
            this(new ExecConfig(), validationEnabled);
    }
    public ExecConfigBuilder(ExecConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ExecConfigBuilder(ExecConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExecConfig(), validationEnabled);
    }
    public ExecConfigBuilder(ExecConfigFluent<?> fluent,ExecConfig instance){
            this(fluent, instance, true);
    }
    public ExecConfigBuilder(ExecConfigFluent<?> fluent,ExecConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttachStderr(instance.getAttachStderr()); 
            fluent.withAttachStdin(instance.getAttachStdin()); 
            fluent.withAttachStdout(instance.getAttachStdout()); 
            fluent.withCmd(instance.getCmd()); 
            fluent.withContainer(instance.getContainer()); 
            fluent.withDetach(instance.getDetach()); 
            fluent.withPrivileged(instance.getPrivileged()); 
            fluent.withTty(instance.getTty()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExecConfigBuilder(ExecConfig instance){
            this(instance,true);
    }
    public ExecConfigBuilder(ExecConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttachStderr(instance.getAttachStderr()); 
            this.withAttachStdin(instance.getAttachStdin()); 
            this.withAttachStdout(instance.getAttachStdout()); 
            this.withCmd(instance.getCmd()); 
            this.withContainer(instance.getContainer()); 
            this.withDetach(instance.getDetach()); 
            this.withPrivileged(instance.getPrivileged()); 
            this.withTty(instance.getTty()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableExecConfig build(){
            EditableExecConfig buildable = new EditableExecConfig(fluent.isAttachStderr(),fluent.isAttachStdin(),fluent.isAttachStdout(),fluent.getCmd(),fluent.getContainer(),fluent.isDetach(),fluent.isPrivileged(),fluent.isTty(),fluent.getUser());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExecConfigBuilder that = (ExecConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
