package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.String;
import java.util.List;
import java.lang.Long;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import lombok.EqualsAndHashCode;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import lombok.ToString;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import javax.annotation.Generated;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

public interface DockerSchemaFluent<A extends DockerSchemaFluent<A>> extends Fluent<A>{


    public Address getAddress();
    public A withAddress(Address Address);
    public DockerSchemaFluent.AddressNested<A> withNewAddress();
    public DockerSchemaFluent.AddressNested<A> withNewAddressLike(Address item);
    public DockerSchemaFluent.AddressNested<A> editAddress();
    public DockerSchemaFluent.AddressNested<A> editOrNewAddress();
    public DockerSchemaFluent.AddressNested<A> editOrNewAddressLike(Address item);
    public A withNewAddress(String Addr,Integer PrefixLen);
    public AuthConfig getAuthConfig();
    public A withAuthConfig(AuthConfig AuthConfig);
    public DockerSchemaFluent.AuthConfigNested<A> withNewAuthConfig();
    public DockerSchemaFluent.AuthConfigNested<A> withNewAuthConfigLike(AuthConfig item);
    public DockerSchemaFluent.AuthConfigNested<A> editAuthConfig();
    public DockerSchemaFluent.AuthConfigNested<A> editOrNewAuthConfig();
    public DockerSchemaFluent.AuthConfigNested<A> editOrNewAuthConfigLike(AuthConfig item);
    public A withNewAuthConfig(String auth,String email,String password,String serveraddress,String username);
    public AuthResponse getAuthResponse();
    public A withAuthResponse(AuthResponse AuthResponse);
    public DockerSchemaFluent.AuthResponseNested<A> withNewAuthResponse();
    public DockerSchemaFluent.AuthResponseNested<A> withNewAuthResponseLike(AuthResponse item);
    public DockerSchemaFluent.AuthResponseNested<A> editAuthResponse();
    public DockerSchemaFluent.AuthResponseNested<A> editOrNewAuthResponse();
    public DockerSchemaFluent.AuthResponseNested<A> editOrNewAuthResponseLike(AuthResponse item);
    public A withNewAuthResponse(String Status);
    public ContainerChange getContainerChange();
    public A withContainerChange(ContainerChange ContainerChange);
    public DockerSchemaFluent.ContainerChangeNested<A> withNewContainerChange();
    public DockerSchemaFluent.ContainerChangeNested<A> withNewContainerChangeLike(ContainerChange item);
    public DockerSchemaFluent.ContainerChangeNested<A> editContainerChange();
    public DockerSchemaFluent.ContainerChangeNested<A> editOrNewContainerChange();
    public DockerSchemaFluent.ContainerChangeNested<A> editOrNewContainerChangeLike(ContainerChange item);
    public A withNewContainerChange(Integer Kind,String Path);
    public ContainerCommitResponse getContainerCommitResponse();
    public A withContainerCommitResponse(ContainerCommitResponse ContainerCommitResponse);
    public DockerSchemaFluent.ContainerCommitResponseNested<A> withNewContainerCommitResponse();
    public DockerSchemaFluent.ContainerCommitResponseNested<A> withNewContainerCommitResponseLike(ContainerCommitResponse item);
    public DockerSchemaFluent.ContainerCommitResponseNested<A> editContainerCommitResponse();
    public DockerSchemaFluent.ContainerCommitResponseNested<A> editOrNewContainerCommitResponse();
    public DockerSchemaFluent.ContainerCommitResponseNested<A> editOrNewContainerCommitResponseLike(ContainerCommitResponse item);
    public A withNewContainerCommitResponse(String Id);
    public ContainerCreateResponse getContainerCreateResponse();
    public A withContainerCreateResponse(ContainerCreateResponse ContainerCreateResponse);
    public DockerSchemaFluent.ContainerCreateResponseNested<A> withNewContainerCreateResponse();
    public DockerSchemaFluent.ContainerCreateResponseNested<A> withNewContainerCreateResponseLike(ContainerCreateResponse item);
    public DockerSchemaFluent.ContainerCreateResponseNested<A> editContainerCreateResponse();
    public DockerSchemaFluent.ContainerCreateResponseNested<A> editOrNewContainerCreateResponse();
    public DockerSchemaFluent.ContainerCreateResponseNested<A> editOrNewContainerCreateResponseLike(ContainerCreateResponse item);
    public ContainerExecCreateResponse getContainerExecCreateResponse();
    public A withContainerExecCreateResponse(ContainerExecCreateResponse ContainerExecCreateResponse);
    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> withNewContainerExecCreateResponse();
    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> withNewContainerExecCreateResponseLike(ContainerExecCreateResponse item);
    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> editContainerExecCreateResponse();
    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> editOrNewContainerExecCreateResponse();
    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> editOrNewContainerExecCreateResponseLike(ContainerExecCreateResponse item);
    public A withNewContainerExecCreateResponse(String Id);
    public ContainerJSONBase getContainerJSONBase();
    public A withContainerJSONBase(ContainerJSONBase ContainerJSONBase);
    public DockerSchemaFluent.ContainerJSONBaseNested<A> withNewContainerJSONBase();
    public DockerSchemaFluent.ContainerJSONBaseNested<A> withNewContainerJSONBaseLike(ContainerJSONBase item);
    public DockerSchemaFluent.ContainerJSONBaseNested<A> editContainerJSONBase();
    public DockerSchemaFluent.ContainerJSONBaseNested<A> editOrNewContainerJSONBase();
    public DockerSchemaFluent.ContainerJSONBaseNested<A> editOrNewContainerJSONBaseLike(ContainerJSONBase item);
    public ContainerPathStat getContainerPathStat();
    public A withContainerPathStat(ContainerPathStat ContainerPathStat);
    public DockerSchemaFluent.ContainerPathStatNested<A> withNewContainerPathStat();
    public DockerSchemaFluent.ContainerPathStatNested<A> withNewContainerPathStatLike(ContainerPathStat item);
    public DockerSchemaFluent.ContainerPathStatNested<A> editContainerPathStat();
    public DockerSchemaFluent.ContainerPathStatNested<A> editOrNewContainerPathStat();
    public DockerSchemaFluent.ContainerPathStatNested<A> editOrNewContainerPathStatLike(ContainerPathStat item);
    public A withNewContainerPathStat(String linkTarget,Integer mode,String mtime,String name,Long size);
    public ContainerProcessList getContainerProcessList();
    public A withContainerProcessList(ContainerProcessList ContainerProcessList);
    public DockerSchemaFluent.ContainerProcessListNested<A> withNewContainerProcessList();
    public DockerSchemaFluent.ContainerProcessListNested<A> withNewContainerProcessListLike(ContainerProcessList item);
    public DockerSchemaFluent.ContainerProcessListNested<A> editContainerProcessList();
    public DockerSchemaFluent.ContainerProcessListNested<A> editOrNewContainerProcessList();
    public DockerSchemaFluent.ContainerProcessListNested<A> editOrNewContainerProcessListLike(ContainerProcessList item);
    public ContainerState getContainerState();
    public A withContainerState(ContainerState ContainerState);
    public DockerSchemaFluent.ContainerStateNested<A> withNewContainerState();
    public DockerSchemaFluent.ContainerStateNested<A> withNewContainerStateLike(ContainerState item);
    public DockerSchemaFluent.ContainerStateNested<A> editContainerState();
    public DockerSchemaFluent.ContainerStateNested<A> editOrNewContainerState();
    public DockerSchemaFluent.ContainerStateNested<A> editOrNewContainerStateLike(ContainerState item);
    public ContainerWaitResponse getContainerWaitResponse();
    public A withContainerWaitResponse(ContainerWaitResponse ContainerWaitResponse);
    public DockerSchemaFluent.ContainerWaitResponseNested<A> withNewContainerWaitResponse();
    public DockerSchemaFluent.ContainerWaitResponseNested<A> withNewContainerWaitResponseLike(ContainerWaitResponse item);
    public DockerSchemaFluent.ContainerWaitResponseNested<A> editContainerWaitResponse();
    public DockerSchemaFluent.ContainerWaitResponseNested<A> editOrNewContainerWaitResponse();
    public DockerSchemaFluent.ContainerWaitResponseNested<A> editOrNewContainerWaitResponseLike(ContainerWaitResponse item);
    public A withNewContainerWaitResponse(Integer StatusCode);
    public CopyConfig getCopyConfig();
    public A withCopyConfig(CopyConfig CopyConfig);
    public DockerSchemaFluent.CopyConfigNested<A> withNewCopyConfig();
    public DockerSchemaFluent.CopyConfigNested<A> withNewCopyConfigLike(CopyConfig item);
    public DockerSchemaFluent.CopyConfigNested<A> editCopyConfig();
    public DockerSchemaFluent.CopyConfigNested<A> editOrNewCopyConfig();
    public DockerSchemaFluent.CopyConfigNested<A> editOrNewCopyConfigLike(CopyConfig item);
    public A withNewCopyConfig(String Resource);
    public DefaultNetworkSettings getDefaultNetworkSettings();
    public A withDefaultNetworkSettings(DefaultNetworkSettings DefaultNetworkSettings);
    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> withNewDefaultNetworkSettings();
    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> withNewDefaultNetworkSettingsLike(DefaultNetworkSettings item);
    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> editDefaultNetworkSettings();
    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> editOrNewDefaultNetworkSettings();
    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> editOrNewDefaultNetworkSettingsLike(DefaultNetworkSettings item);
    public EndpointResource getEndpointResource();
    public A withEndpointResource(EndpointResource EndpointResource);
    public DockerSchemaFluent.EndpointResourceNested<A> withNewEndpointResource();
    public DockerSchemaFluent.EndpointResourceNested<A> withNewEndpointResourceLike(EndpointResource item);
    public DockerSchemaFluent.EndpointResourceNested<A> editEndpointResource();
    public DockerSchemaFluent.EndpointResourceNested<A> editOrNewEndpointResource();
    public DockerSchemaFluent.EndpointResourceNested<A> editOrNewEndpointResourceLike(EndpointResource item);
    public A withNewEndpointResource(String EndpointID,String IPv4Address,String IPv6Address,String MacAddress);
    public EndpointSettings getEndpointSettings();
    public A withEndpointSettings(EndpointSettings EndpointSettings);
    public DockerSchemaFluent.EndpointSettingsNested<A> withNewEndpointSettings();
    public DockerSchemaFluent.EndpointSettingsNested<A> withNewEndpointSettingsLike(EndpointSettings item);
    public DockerSchemaFluent.EndpointSettingsNested<A> editEndpointSettings();
    public DockerSchemaFluent.EndpointSettingsNested<A> editOrNewEndpointSettings();
    public DockerSchemaFluent.EndpointSettingsNested<A> editOrNewEndpointSettingsLike(EndpointSettings item);
    public ExecConfig getExecConfig();
    public A withExecConfig(ExecConfig ExecConfig);
    public DockerSchemaFluent.ExecConfigNested<A> withNewExecConfig();
    public DockerSchemaFluent.ExecConfigNested<A> withNewExecConfigLike(ExecConfig item);
    public DockerSchemaFluent.ExecConfigNested<A> editExecConfig();
    public DockerSchemaFluent.ExecConfigNested<A> editOrNewExecConfig();
    public DockerSchemaFluent.ExecConfigNested<A> editOrNewExecConfigLike(ExecConfig item);
    public ExecStartCheck getExecStartCheck();
    public A withExecStartCheck(ExecStartCheck ExecStartCheck);
    public DockerSchemaFluent.ExecStartCheckNested<A> withNewExecStartCheck();
    public DockerSchemaFluent.ExecStartCheckNested<A> withNewExecStartCheckLike(ExecStartCheck item);
    public DockerSchemaFluent.ExecStartCheckNested<A> editExecStartCheck();
    public DockerSchemaFluent.ExecStartCheckNested<A> editOrNewExecStartCheck();
    public DockerSchemaFluent.ExecStartCheckNested<A> editOrNewExecStartCheckLike(ExecStartCheck item);
    public A withNewExecStartCheck(Boolean Detach,Boolean Tty);
    public GraphDriverData getGraphDriverData();
    public A withGraphDriverData(GraphDriverData GraphDriverData);
    public DockerSchemaFluent.GraphDriverDataNested<A> withNewGraphDriverData();
    public DockerSchemaFluent.GraphDriverDataNested<A> withNewGraphDriverDataLike(GraphDriverData item);
    public DockerSchemaFluent.GraphDriverDataNested<A> editGraphDriverData();
    public DockerSchemaFluent.GraphDriverDataNested<A> editOrNewGraphDriverData();
    public DockerSchemaFluent.GraphDriverDataNested<A> editOrNewGraphDriverDataLike(GraphDriverData item);
    public HostConfig getHostConfig();
    public A withHostConfig(HostConfig HostConfig);
    public DockerSchemaFluent.HostConfigNested<A> withNewHostConfig();
    public DockerSchemaFluent.HostConfigNested<A> withNewHostConfigLike(HostConfig item);
    public DockerSchemaFluent.HostConfigNested<A> editHostConfig();
    public DockerSchemaFluent.HostConfigNested<A> editOrNewHostConfig();
    public DockerSchemaFluent.HostConfigNested<A> editOrNewHostConfigLike(HostConfig item);
    public IPAM getIPAM();
    public A withIPAM(IPAM IPAM);
    public DockerSchemaFluent.IPAMNested<A> withNewIPAM();
    public DockerSchemaFluent.IPAMNested<A> withNewIPAMLike(IPAM item);
    public DockerSchemaFluent.IPAMNested<A> editIPAM();
    public DockerSchemaFluent.IPAMNested<A> editOrNewIPAM();
    public DockerSchemaFluent.IPAMNested<A> editOrNewIPAMLike(IPAM item);
    public IPAMConfig getIPAMConfig();
    public A withIPAMConfig(IPAMConfig IPAMConfig);
    public DockerSchemaFluent.IPAMConfigNested<A> withNewIPAMConfig();
    public DockerSchemaFluent.IPAMConfigNested<A> withNewIPAMConfigLike(IPAMConfig item);
    public DockerSchemaFluent.IPAMConfigNested<A> editIPAMConfig();
    public DockerSchemaFluent.IPAMConfigNested<A> editOrNewIPAMConfig();
    public DockerSchemaFluent.IPAMConfigNested<A> editOrNewIPAMConfigLike(IPAMConfig item);
    public Image getImage();
    public A withImage(Image Image);
    public DockerSchemaFluent.ImageNested<A> withNewImage();
    public DockerSchemaFluent.ImageNested<A> withNewImageLike(Image item);
    public DockerSchemaFluent.ImageNested<A> editImage();
    public DockerSchemaFluent.ImageNested<A> editOrNewImage();
    public DockerSchemaFluent.ImageNested<A> editOrNewImageLike(Image item);
    public ImageDelete getImageDelete();
    public A withImageDelete(ImageDelete ImageDelete);
    public DockerSchemaFluent.ImageDeleteNested<A> withNewImageDelete();
    public DockerSchemaFluent.ImageDeleteNested<A> withNewImageDeleteLike(ImageDelete item);
    public DockerSchemaFluent.ImageDeleteNested<A> editImageDelete();
    public DockerSchemaFluent.ImageDeleteNested<A> editOrNewImageDelete();
    public DockerSchemaFluent.ImageDeleteNested<A> editOrNewImageDeleteLike(ImageDelete item);
    public A withNewImageDelete(String Deleted,String Untagged);
    public ImageHistory getImageHistory();
    public A withImageHistory(ImageHistory ImageHistory);
    public DockerSchemaFluent.ImageHistoryNested<A> withNewImageHistory();
    public DockerSchemaFluent.ImageHistoryNested<A> withNewImageHistoryLike(ImageHistory item);
    public DockerSchemaFluent.ImageHistoryNested<A> editImageHistory();
    public DockerSchemaFluent.ImageHistoryNested<A> editOrNewImageHistory();
    public DockerSchemaFluent.ImageHistoryNested<A> editOrNewImageHistoryLike(ImageHistory item);
    public ImageInspect getImageInspect();
    public A withImageInspect(ImageInspect ImageInspect);
    public DockerSchemaFluent.ImageInspectNested<A> withNewImageInspect();
    public DockerSchemaFluent.ImageInspectNested<A> withNewImageInspectLike(ImageInspect item);
    public DockerSchemaFluent.ImageInspectNested<A> editImageInspect();
    public DockerSchemaFluent.ImageInspectNested<A> editOrNewImageInspect();
    public DockerSchemaFluent.ImageInspectNested<A> editOrNewImageInspectLike(ImageInspect item);
    public IndexInfo getIndexInfo();
    public A withIndexInfo(IndexInfo IndexInfo);
    public DockerSchemaFluent.IndexInfoNested<A> withNewIndexInfo();
    public DockerSchemaFluent.IndexInfoNested<A> withNewIndexInfoLike(IndexInfo item);
    public DockerSchemaFluent.IndexInfoNested<A> editIndexInfo();
    public DockerSchemaFluent.IndexInfoNested<A> editOrNewIndexInfo();
    public DockerSchemaFluent.IndexInfoNested<A> editOrNewIndexInfoLike(IndexInfo item);
    public Info getInfo();
    public A withInfo(Info Info);
    public DockerSchemaFluent.InfoNested<A> withNewInfo();
    public DockerSchemaFluent.InfoNested<A> withNewInfoLike(Info item);
    public DockerSchemaFluent.InfoNested<A> editInfo();
    public DockerSchemaFluent.InfoNested<A> editOrNewInfo();
    public DockerSchemaFluent.InfoNested<A> editOrNewInfoLike(Info item);
    public KeyValuePair getKeyValuePair();
    public A withKeyValuePair(KeyValuePair KeyValuePair);
    public DockerSchemaFluent.KeyValuePairNested<A> withNewKeyValuePair();
    public DockerSchemaFluent.KeyValuePairNested<A> withNewKeyValuePairLike(KeyValuePair item);
    public DockerSchemaFluent.KeyValuePairNested<A> editKeyValuePair();
    public DockerSchemaFluent.KeyValuePairNested<A> editOrNewKeyValuePair();
    public DockerSchemaFluent.KeyValuePairNested<A> editOrNewKeyValuePairLike(KeyValuePair item);
    public A withNewKeyValuePair(String Key,String Value);
    public LogConfig getLogConfig();
    public A withLogConfig(LogConfig LogConfig);
    public DockerSchemaFluent.LogConfigNested<A> withNewLogConfig();
    public DockerSchemaFluent.LogConfigNested<A> withNewLogConfigLike(LogConfig item);
    public DockerSchemaFluent.LogConfigNested<A> editLogConfig();
    public DockerSchemaFluent.LogConfigNested<A> editOrNewLogConfig();
    public DockerSchemaFluent.LogConfigNested<A> editOrNewLogConfigLike(LogConfig item);
    public MountPoint getMountPoint();
    public A withMountPoint(MountPoint MountPoint);
    public DockerSchemaFluent.MountPointNested<A> withNewMountPoint();
    public DockerSchemaFluent.MountPointNested<A> withNewMountPointLike(MountPoint item);
    public DockerSchemaFluent.MountPointNested<A> editMountPoint();
    public DockerSchemaFluent.MountPointNested<A> editOrNewMountPoint();
    public DockerSchemaFluent.MountPointNested<A> editOrNewMountPointLike(MountPoint item);
    public NetworkConnect getNetworkConnect();
    public A withNetworkConnect(NetworkConnect NetworkConnect);
    public DockerSchemaFluent.NetworkConnectNested<A> withNewNetworkConnect();
    public DockerSchemaFluent.NetworkConnectNested<A> withNewNetworkConnectLike(NetworkConnect item);
    public DockerSchemaFluent.NetworkConnectNested<A> editNetworkConnect();
    public DockerSchemaFluent.NetworkConnectNested<A> editOrNewNetworkConnect();
    public DockerSchemaFluent.NetworkConnectNested<A> editOrNewNetworkConnectLike(NetworkConnect item);
    public A withNewNetworkConnect(String Container);
    public NetworkCreate getNetworkCreate();
    public A withNetworkCreate(NetworkCreate NetworkCreate);
    public DockerSchemaFluent.NetworkCreateNested<A> withNewNetworkCreate();
    public DockerSchemaFluent.NetworkCreateNested<A> withNewNetworkCreateLike(NetworkCreate item);
    public DockerSchemaFluent.NetworkCreateNested<A> editNetworkCreate();
    public DockerSchemaFluent.NetworkCreateNested<A> editOrNewNetworkCreate();
    public DockerSchemaFluent.NetworkCreateNested<A> editOrNewNetworkCreateLike(NetworkCreate item);
    public NetworkCreateResponse getNetworkCreateResponse();
    public A withNetworkCreateResponse(NetworkCreateResponse NetworkCreateResponse);
    public DockerSchemaFluent.NetworkCreateResponseNested<A> withNewNetworkCreateResponse();
    public DockerSchemaFluent.NetworkCreateResponseNested<A> withNewNetworkCreateResponseLike(NetworkCreateResponse item);
    public DockerSchemaFluent.NetworkCreateResponseNested<A> editNetworkCreateResponse();
    public DockerSchemaFluent.NetworkCreateResponseNested<A> editOrNewNetworkCreateResponse();
    public DockerSchemaFluent.NetworkCreateResponseNested<A> editOrNewNetworkCreateResponseLike(NetworkCreateResponse item);
    public A withNewNetworkCreateResponse(String Id,String Warning);
    public NetworkDisconnect getNetworkDisconnect();
    public A withNetworkDisconnect(NetworkDisconnect NetworkDisconnect);
    public DockerSchemaFluent.NetworkDisconnectNested<A> withNewNetworkDisconnect();
    public DockerSchemaFluent.NetworkDisconnectNested<A> withNewNetworkDisconnectLike(NetworkDisconnect item);
    public DockerSchemaFluent.NetworkDisconnectNested<A> editNetworkDisconnect();
    public DockerSchemaFluent.NetworkDisconnectNested<A> editOrNewNetworkDisconnect();
    public DockerSchemaFluent.NetworkDisconnectNested<A> editOrNewNetworkDisconnectLike(NetworkDisconnect item);
    public A withNewNetworkDisconnect(String Container);
    public NetworkResource getNetworkResource();
    public A withNetworkResource(NetworkResource NetworkResource);
    public DockerSchemaFluent.NetworkResourceNested<A> withNewNetworkResource();
    public DockerSchemaFluent.NetworkResourceNested<A> withNewNetworkResourceLike(NetworkResource item);
    public DockerSchemaFluent.NetworkResourceNested<A> editNetworkResource();
    public DockerSchemaFluent.NetworkResourceNested<A> editOrNewNetworkResource();
    public DockerSchemaFluent.NetworkResourceNested<A> editOrNewNetworkResourceLike(NetworkResource item);
    public NetworkSettings getNetworkSettings();
    public A withNetworkSettings(NetworkSettings NetworkSettings);
    public DockerSchemaFluent.NetworkSettingsNested<A> withNewNetworkSettings();
    public DockerSchemaFluent.NetworkSettingsNested<A> withNewNetworkSettingsLike(NetworkSettings item);
    public DockerSchemaFluent.NetworkSettingsNested<A> editNetworkSettings();
    public DockerSchemaFluent.NetworkSettingsNested<A> editOrNewNetworkSettings();
    public DockerSchemaFluent.NetworkSettingsNested<A> editOrNewNetworkSettingsLike(NetworkSettings item);
    public NetworkSettingsBase getNetworkSettingsBase();
    public A withNetworkSettingsBase(NetworkSettingsBase NetworkSettingsBase);
    public DockerSchemaFluent.NetworkSettingsBaseNested<A> withNewNetworkSettingsBase();
    public DockerSchemaFluent.NetworkSettingsBaseNested<A> withNewNetworkSettingsBaseLike(NetworkSettingsBase item);
    public DockerSchemaFluent.NetworkSettingsBaseNested<A> editNetworkSettingsBase();
    public DockerSchemaFluent.NetworkSettingsBaseNested<A> editOrNewNetworkSettingsBase();
    public DockerSchemaFluent.NetworkSettingsBaseNested<A> editOrNewNetworkSettingsBaseLike(NetworkSettingsBase item);
    public Port getPort();
    public A withPort(Port Port);
    public DockerSchemaFluent.PortNested<A> withNewPort();
    public DockerSchemaFluent.PortNested<A> withNewPortLike(Port item);
    public DockerSchemaFluent.PortNested<A> editPort();
    public DockerSchemaFluent.PortNested<A> editOrNewPort();
    public DockerSchemaFluent.PortNested<A> editOrNewPortLike(Port item);
    public A withNewPort(String IP,Integer PrivatePort,Integer PublicPort,String Type);
    public PortBinding getPortBinding();
    public A withPortBinding(PortBinding PortBinding);
    public DockerSchemaFluent.PortBindingNested<A> withNewPortBinding();
    public DockerSchemaFluent.PortBindingNested<A> withNewPortBindingLike(PortBinding item);
    public DockerSchemaFluent.PortBindingNested<A> editPortBinding();
    public DockerSchemaFluent.PortBindingNested<A> editOrNewPortBinding();
    public DockerSchemaFluent.PortBindingNested<A> editOrNewPortBindingLike(PortBinding item);
    public A withNewPortBinding(String HostIp,String HostPort);
    public SearchResult getSearchResult();
    public A withSearchResult(SearchResult SearchResult);
    public DockerSchemaFluent.SearchResultNested<A> withNewSearchResult();
    public DockerSchemaFluent.SearchResultNested<A> withNewSearchResultLike(SearchResult item);
    public DockerSchemaFluent.SearchResultNested<A> editSearchResult();
    public DockerSchemaFluent.SearchResultNested<A> editOrNewSearchResult();
    public DockerSchemaFluent.SearchResultNested<A> editOrNewSearchResultLike(SearchResult item);
    public SearchResults getSearchResults();
    public A withSearchResults(SearchResults SearchResults);
    public DockerSchemaFluent.SearchResultsNested<A> withNewSearchResults();
    public DockerSchemaFluent.SearchResultsNested<A> withNewSearchResultsLike(SearchResults item);
    public DockerSchemaFluent.SearchResultsNested<A> editSearchResults();
    public DockerSchemaFluent.SearchResultsNested<A> editOrNewSearchResults();
    public DockerSchemaFluent.SearchResultsNested<A> editOrNewSearchResultsLike(SearchResults item);
    public ServiceConfig getServiceConfig();
    public A withServiceConfig(ServiceConfig ServiceConfig);
    public DockerSchemaFluent.ServiceConfigNested<A> withNewServiceConfig();
    public DockerSchemaFluent.ServiceConfigNested<A> withNewServiceConfigLike(ServiceConfig item);
    public DockerSchemaFluent.ServiceConfigNested<A> editServiceConfig();
    public DockerSchemaFluent.ServiceConfigNested<A> editOrNewServiceConfig();
    public DockerSchemaFluent.ServiceConfigNested<A> editOrNewServiceConfigLike(ServiceConfig item);
    public Stats getStats();
    public A withStats(Stats Stats);
    public DockerSchemaFluent.StatsNested<A> withNewStats();
    public DockerSchemaFluent.StatsNested<A> withNewStatsLike(Stats item);
    public DockerSchemaFluent.StatsNested<A> editStats();
    public DockerSchemaFluent.StatsNested<A> editOrNewStats();
    public DockerSchemaFluent.StatsNested<A> editOrNewStatsLike(Stats item);
    public A addToStrSlice(String... items);
    public A removeFromStrSlice(String... items);
    public List<String> getStrSlice();
    public A withStrSlice(List<String> StrSlice);
    public A withStrSlice(String... StrSlice);
    public io.fabric8.docker.api.model.Version getVersion();
    public A withVersion(io.fabric8.docker.api.model.Version Version);
    public DockerSchemaFluent.VersionNested<A> withNewVersion();
    public DockerSchemaFluent.VersionNested<A> withNewVersionLike(io.fabric8.docker.api.model.Version item);
    public DockerSchemaFluent.VersionNested<A> editVersion();
    public DockerSchemaFluent.VersionNested<A> editOrNewVersion();
    public DockerSchemaFluent.VersionNested<A> editOrNewVersionLike(io.fabric8.docker.api.model.Version item);
    public Volume getVolume();
    public A withVolume(Volume Volume);
    public DockerSchemaFluent.VolumeNested<A> withNewVolume();
    public DockerSchemaFluent.VolumeNested<A> withNewVolumeLike(Volume item);
    public DockerSchemaFluent.VolumeNested<A> editVolume();
    public DockerSchemaFluent.VolumeNested<A> editOrNewVolume();
    public DockerSchemaFluent.VolumeNested<A> editOrNewVolumeLike(Volume item);
    public A withNewVolume(String Driver,String Mountpoint,String Name);
    public VolumeCreateRequest getVolumeCreateRequest();
    public A withVolumeCreateRequest(VolumeCreateRequest VolumeCreateRequest);
    public DockerSchemaFluent.VolumeCreateRequestNested<A> withNewVolumeCreateRequest();
    public DockerSchemaFluent.VolumeCreateRequestNested<A> withNewVolumeCreateRequestLike(VolumeCreateRequest item);
    public DockerSchemaFluent.VolumeCreateRequestNested<A> editVolumeCreateRequest();
    public DockerSchemaFluent.VolumeCreateRequestNested<A> editOrNewVolumeCreateRequest();
    public DockerSchemaFluent.VolumeCreateRequestNested<A> editOrNewVolumeCreateRequestLike(VolumeCreateRequest item);
    public VolumesListResponse getVolumesListResponse();
    public A withVolumesListResponse(VolumesListResponse VolumesListResponse);
    public DockerSchemaFluent.VolumesListResponseNested<A> withNewVolumesListResponse();
    public DockerSchemaFluent.VolumesListResponseNested<A> withNewVolumesListResponseLike(VolumesListResponse item);
    public DockerSchemaFluent.VolumesListResponseNested<A> editVolumesListResponse();
    public DockerSchemaFluent.VolumesListResponseNested<A> editOrNewVolumesListResponse();
    public DockerSchemaFluent.VolumesListResponseNested<A> editOrNewVolumesListResponseLike(VolumesListResponse item);

    public interface AddressNested<N> extends io.fabric8.docker.api.builder.Nested<N>,AddressFluent<DockerSchemaFluent.AddressNested<N>>{

        
    public N and();    public N endAddress();
}
    public interface AuthConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,AuthConfigFluent<DockerSchemaFluent.AuthConfigNested<N>>{

        
    public N and();    public N endAuthConfig();
}
    public interface AuthResponseNested<N> extends io.fabric8.docker.api.builder.Nested<N>,AuthResponseFluent<DockerSchemaFluent.AuthResponseNested<N>>{

        
    public N and();    public N endAuthResponse();
}
    public interface ContainerChangeNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerChangeFluent<DockerSchemaFluent.ContainerChangeNested<N>>{

        
    public N and();    public N endContainerChange();
}
    public interface ContainerCommitResponseNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerCommitResponseFluent<DockerSchemaFluent.ContainerCommitResponseNested<N>>{

        
    public N and();    public N endContainerCommitResponse();
}
    public interface ContainerCreateResponseNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerCreateResponseFluent<DockerSchemaFluent.ContainerCreateResponseNested<N>>{

        
    public N and();    public N endContainerCreateResponse();
}
    public interface ContainerExecCreateResponseNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerExecCreateResponseFluent<DockerSchemaFluent.ContainerExecCreateResponseNested<N>>{

        
    public N and();    public N endContainerExecCreateResponse();
}
    public interface ContainerJSONBaseNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerJSONBaseFluent<DockerSchemaFluent.ContainerJSONBaseNested<N>>{

        
    public N and();    public N endContainerJSONBase();
}
    public interface ContainerPathStatNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerPathStatFluent<DockerSchemaFluent.ContainerPathStatNested<N>>{

        
    public N and();    public N endContainerPathStat();
}
    public interface ContainerProcessListNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerProcessListFluent<DockerSchemaFluent.ContainerProcessListNested<N>>{

        
    public N and();    public N endContainerProcessList();
}
    public interface ContainerStateNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerStateFluent<DockerSchemaFluent.ContainerStateNested<N>>{

        
    public N and();    public N endContainerState();
}
    public interface ContainerWaitResponseNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerWaitResponseFluent<DockerSchemaFluent.ContainerWaitResponseNested<N>>{

        
    public N and();    public N endContainerWaitResponse();
}
    public interface CopyConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,CopyConfigFluent<DockerSchemaFluent.CopyConfigNested<N>>{

        
    public N and();    public N endCopyConfig();
}
    public interface DefaultNetworkSettingsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,DefaultNetworkSettingsFluent<DockerSchemaFluent.DefaultNetworkSettingsNested<N>>{

        
    public N and();    public N endDefaultNetworkSettings();
}
    public interface EndpointResourceNested<N> extends io.fabric8.docker.api.builder.Nested<N>,EndpointResourceFluent<DockerSchemaFluent.EndpointResourceNested<N>>{

        
    public N and();    public N endEndpointResource();
}
    public interface EndpointSettingsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,EndpointSettingsFluent<DockerSchemaFluent.EndpointSettingsNested<N>>{

        
    public N and();    public N endEndpointSettings();
}
    public interface ExecConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ExecConfigFluent<DockerSchemaFluent.ExecConfigNested<N>>{

        
    public N and();    public N endExecConfig();
}
    public interface ExecStartCheckNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ExecStartCheckFluent<DockerSchemaFluent.ExecStartCheckNested<N>>{

        
    public N and();    public N endExecStartCheck();
}
    public interface GraphDriverDataNested<N> extends io.fabric8.docker.api.builder.Nested<N>,GraphDriverDataFluent<DockerSchemaFluent.GraphDriverDataNested<N>>{

        
    public N and();    public N endGraphDriverData();
}
    public interface HostConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,HostConfigFluent<DockerSchemaFluent.HostConfigNested<N>>{

        
    public N and();    public N endHostConfig();
}
    public interface IPAMNested<N> extends io.fabric8.docker.api.builder.Nested<N>,IPAMFluent<DockerSchemaFluent.IPAMNested<N>>{

        
    public N and();    public N endIPAM();
}
    public interface IPAMConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,IPAMConfigFluent<DockerSchemaFluent.IPAMConfigNested<N>>{

        
    public N and();    public N endIPAMConfig();
}
    public interface ImageNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ImageFluent<DockerSchemaFluent.ImageNested<N>>{

        
    public N and();    public N endImage();
}
    public interface ImageDeleteNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ImageDeleteFluent<DockerSchemaFluent.ImageDeleteNested<N>>{

        
    public N and();    public N endImageDelete();
}
    public interface ImageHistoryNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ImageHistoryFluent<DockerSchemaFluent.ImageHistoryNested<N>>{

        
    public N and();    public N endImageHistory();
}
    public interface ImageInspectNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ImageInspectFluent<DockerSchemaFluent.ImageInspectNested<N>>{

        
    public N and();    public N endImageInspect();
}
    public interface IndexInfoNested<N> extends io.fabric8.docker.api.builder.Nested<N>,IndexInfoFluent<DockerSchemaFluent.IndexInfoNested<N>>{

        
    public N and();    public N endIndexInfo();
}
    public interface InfoNested<N> extends io.fabric8.docker.api.builder.Nested<N>,InfoFluent<DockerSchemaFluent.InfoNested<N>>{

        
    public N and();    public N endInfo();
}
    public interface KeyValuePairNested<N> extends io.fabric8.docker.api.builder.Nested<N>,KeyValuePairFluent<DockerSchemaFluent.KeyValuePairNested<N>>{

        
    public N and();    public N endKeyValuePair();
}
    public interface LogConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,LogConfigFluent<DockerSchemaFluent.LogConfigNested<N>>{

        
    public N and();    public N endLogConfig();
}
    public interface MountPointNested<N> extends io.fabric8.docker.api.builder.Nested<N>,MountPointFluent<DockerSchemaFluent.MountPointNested<N>>{

        
    public N and();    public N endMountPoint();
}
    public interface NetworkConnectNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetworkConnectFluent<DockerSchemaFluent.NetworkConnectNested<N>>{

        
    public N and();    public N endNetworkConnect();
}
    public interface NetworkCreateNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetworkCreateFluent<DockerSchemaFluent.NetworkCreateNested<N>>{

        
    public N and();    public N endNetworkCreate();
}
    public interface NetworkCreateResponseNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetworkCreateResponseFluent<DockerSchemaFluent.NetworkCreateResponseNested<N>>{

        
    public N and();    public N endNetworkCreateResponse();
}
    public interface NetworkDisconnectNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetworkDisconnectFluent<DockerSchemaFluent.NetworkDisconnectNested<N>>{

        
    public N and();    public N endNetworkDisconnect();
}
    public interface NetworkResourceNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetworkResourceFluent<DockerSchemaFluent.NetworkResourceNested<N>>{

        
    public N and();    public N endNetworkResource();
}
    public interface NetworkSettingsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetworkSettingsFluent<DockerSchemaFluent.NetworkSettingsNested<N>>{

        
    public N and();    public N endNetworkSettings();
}
    public interface NetworkSettingsBaseNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetworkSettingsBaseFluent<DockerSchemaFluent.NetworkSettingsBaseNested<N>>{

        
    public N and();    public N endNetworkSettingsBase();
}
    public interface PortNested<N> extends io.fabric8.docker.api.builder.Nested<N>,PortFluent<DockerSchemaFluent.PortNested<N>>{

        
    public N and();    public N endPort();
}
    public interface PortBindingNested<N> extends io.fabric8.docker.api.builder.Nested<N>,PortBindingFluent<DockerSchemaFluent.PortBindingNested<N>>{

        
    public N and();    public N endPortBinding();
}
    public interface SearchResultNested<N> extends io.fabric8.docker.api.builder.Nested<N>,SearchResultFluent<DockerSchemaFluent.SearchResultNested<N>>{

        
    public N and();    public N endSearchResult();
}
    public interface SearchResultsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,SearchResultsFluent<DockerSchemaFluent.SearchResultsNested<N>>{

        
    public N and();    public N endSearchResults();
}
    public interface ServiceConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ServiceConfigFluent<DockerSchemaFluent.ServiceConfigNested<N>>{

        
    public N and();    public N endServiceConfig();
}
    public interface StatsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,StatsFluent<DockerSchemaFluent.StatsNested<N>>{

        
    public N and();    public N endStats();
}
    public interface VersionNested<N> extends io.fabric8.docker.api.builder.Nested<N>,VersionFluent<DockerSchemaFluent.VersionNested<N>>{

        
    public N and();    public N endVersion();
}
    public interface VolumeNested<N> extends io.fabric8.docker.api.builder.Nested<N>,VolumeFluent<DockerSchemaFluent.VolumeNested<N>>{

        
    public N and();    public N endVolume();
}
    public interface VolumeCreateRequestNested<N> extends io.fabric8.docker.api.builder.Nested<N>,VolumeCreateRequestFluent<DockerSchemaFluent.VolumeCreateRequestNested<N>>{

        
    public N and();    public N endVolumeCreateRequest();
}
    public interface VolumesListResponseNested<N> extends io.fabric8.docker.api.builder.Nested<N>,VolumesListResponseFluent<DockerSchemaFluent.VolumesListResponseNested<N>>{

        
    public N and();    public N endVolumesListResponse();
}


}
