package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class DefaultNetworkSettingsBuilder extends DefaultNetworkSettingsFluentImpl<DefaultNetworkSettingsBuilder> implements VisitableBuilder<DefaultNetworkSettings,DefaultNetworkSettingsBuilder>{

    DefaultNetworkSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public DefaultNetworkSettingsBuilder(){
            this(true);
    }
    public DefaultNetworkSettingsBuilder(Boolean validationEnabled){
            this(new DefaultNetworkSettings(), validationEnabled);
    }
    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DefaultNetworkSettings(), validationEnabled);
    }
    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent,DefaultNetworkSettings instance){
            this(fluent, instance, true);
    }
    public DefaultNetworkSettingsBuilder(DefaultNetworkSettingsFluent<?> fluent,DefaultNetworkSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEndpointID(instance.getEndpointID()); 
            fluent.withGateway(instance.getGateway()); 
            fluent.withGlobalIPv6Address(instance.getGlobalIPv6Address()); 
            fluent.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); 
            fluent.withIPAddress(instance.getIPAddress()); 
            fluent.withIPPrefixLen(instance.getIPPrefixLen()); 
            fluent.withIPv6Gateway(instance.getIPv6Gateway()); 
            fluent.withMacAddress(instance.getMacAddress()); 
            this.validationEnabled = validationEnabled; 
    }
    public DefaultNetworkSettingsBuilder(DefaultNetworkSettings instance){
            this(instance,true);
    }
    public DefaultNetworkSettingsBuilder(DefaultNetworkSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEndpointID(instance.getEndpointID()); 
            this.withGateway(instance.getGateway()); 
            this.withGlobalIPv6Address(instance.getGlobalIPv6Address()); 
            this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); 
            this.withIPAddress(instance.getIPAddress()); 
            this.withIPPrefixLen(instance.getIPPrefixLen()); 
            this.withIPv6Gateway(instance.getIPv6Gateway()); 
            this.withMacAddress(instance.getMacAddress()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableDefaultNetworkSettings build(){
            EditableDefaultNetworkSettings buildable = new EditableDefaultNetworkSettings(fluent.getEndpointID(),fluent.getGateway(),fluent.getGlobalIPv6Address(),fluent.getGlobalIPv6PrefixLen(),fluent.getIPAddress(),fluent.getIPPrefixLen(),fluent.getIPv6Gateway(),fluent.getMacAddress());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DefaultNetworkSettingsBuilder that = (DefaultNetworkSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
