package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class CopyConfigBuilder extends CopyConfigFluentImpl<CopyConfigBuilder> implements VisitableBuilder<CopyConfig,CopyConfigBuilder>{

    CopyConfigFluent<?> fluent;
    Boolean validationEnabled;

    public CopyConfigBuilder(){
            this(true);
    }
    public CopyConfigBuilder(Boolean validationEnabled){
            this(new CopyConfig(), validationEnabled);
    }
    public CopyConfigBuilder(CopyConfigFluent<?> fluent){
            this(fluent, true);
    }
    public CopyConfigBuilder(CopyConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CopyConfig(), validationEnabled);
    }
    public CopyConfigBuilder(CopyConfigFluent<?> fluent,CopyConfig instance){
            this(fluent, instance, true);
    }
    public CopyConfigBuilder(CopyConfigFluent<?> fluent,CopyConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }
    public CopyConfigBuilder(CopyConfig instance){
            this(instance,true);
    }
    public CopyConfigBuilder(CopyConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableCopyConfig build(){
            EditableCopyConfig buildable = new EditableCopyConfig(fluent.getResource());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CopyConfigBuilder that = (CopyConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
