package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ContainerWaitResponseBuilder extends ContainerWaitResponseFluentImpl<ContainerWaitResponseBuilder> implements VisitableBuilder<ContainerWaitResponse,ContainerWaitResponseBuilder>{

    ContainerWaitResponseFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerWaitResponseBuilder(){
            this(true);
    }
    public ContainerWaitResponseBuilder(Boolean validationEnabled){
            this(new ContainerWaitResponse(), validationEnabled);
    }
    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerWaitResponse(), validationEnabled);
    }
    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent,ContainerWaitResponse instance){
            this(fluent, instance, true);
    }
    public ContainerWaitResponseBuilder(ContainerWaitResponseFluent<?> fluent,ContainerWaitResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withStatusCode(instance.getStatusCode()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerWaitResponseBuilder(ContainerWaitResponse instance){
            this(instance,true);
    }
    public ContainerWaitResponseBuilder(ContainerWaitResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withStatusCode(instance.getStatusCode()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerWaitResponse build(){
            EditableContainerWaitResponse buildable = new EditableContainerWaitResponse(fluent.getStatusCode());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerWaitResponseBuilder that = (ContainerWaitResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
