package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ContainerStateBuilder extends ContainerStateFluentImpl<ContainerStateBuilder> implements VisitableBuilder<ContainerState,ContainerStateBuilder>{

    ContainerStateFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStateBuilder(){
            this(true);
    }
    public ContainerStateBuilder(Boolean validationEnabled){
            this(new ContainerState(), validationEnabled);
    }
    public ContainerStateBuilder(ContainerStateFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerStateBuilder(ContainerStateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerState(), validationEnabled);
    }
    public ContainerStateBuilder(ContainerStateFluent<?> fluent,ContainerState instance){
            this(fluent, instance, true);
    }
    public ContainerStateBuilder(ContainerStateFluent<?> fluent,ContainerState instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDead(instance.getDead()); 
            fluent.withError(instance.getError()); 
            fluent.withExitCode(instance.getExitCode()); 
            fluent.withFinishedAt(instance.getFinishedAt()); 
            fluent.withOOMKilled(instance.getOOMKilled()); 
            fluent.withPaused(instance.getPaused()); 
            fluent.withPid(instance.getPid()); 
            fluent.withRestarting(instance.getRestarting()); 
            fluent.withRunning(instance.getRunning()); 
            fluent.withStartedAt(instance.getStartedAt()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerStateBuilder(ContainerState instance){
            this(instance,true);
    }
    public ContainerStateBuilder(ContainerState instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDead(instance.getDead()); 
            this.withError(instance.getError()); 
            this.withExitCode(instance.getExitCode()); 
            this.withFinishedAt(instance.getFinishedAt()); 
            this.withOOMKilled(instance.getOOMKilled()); 
            this.withPaused(instance.getPaused()); 
            this.withPid(instance.getPid()); 
            this.withRestarting(instance.getRestarting()); 
            this.withRunning(instance.getRunning()); 
            this.withStartedAt(instance.getStartedAt()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerState build(){
            EditableContainerState buildable = new EditableContainerState(fluent.isDead(),fluent.getError(),fluent.getExitCode(),fluent.getFinishedAt(),fluent.isOOMKilled(),fluent.isPaused(),fluent.getPid(),fluent.isRestarting(),fluent.isRunning(),fluent.getStartedAt(),fluent.getStatus());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerStateBuilder that = (ContainerStateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
