package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class ContainerProcessListFluentImpl<A extends ContainerProcessListFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ContainerProcessListFluent<A>{

    private List<List<String>> Processes = new ArrayList<List<String>>();
    private List<String> Titles = new ArrayList<String>();

    public ContainerProcessListFluentImpl(){
    }
    public ContainerProcessListFluentImpl(ContainerProcessList instance){
            this.withProcesses(instance.getProcesses()); 
            this.withTitles(instance.getTitles()); 
    }

    public A addToProcesses(List<String>... items){
            for (List<String> item : items) {this.Processes.add(item);} return (A)this;
    }

    public A removeFromProcesses(List<String>... items){
            for (List<String> item : items) {this.Processes.remove(item);} return (A)this;
    }

    public List<List<String>> getProcesses(){
            return this.Processes;
    }

    public A withProcesses(List<List<String>> Processes){
            this.Processes.clear();
            if (Processes != null) {for (List<String> item : Processes){this.addToProcesses(item);}} return (A) this;
    }

    public A withProcesses(List<String>... Processes){
            this.Processes.clear(); if (Processes != null) {for (List<String> item :Processes){ this.addToProcesses(item);}} return (A) this;
    }

    public A addToTitles(String... items){
            for (String item : items) {this.Titles.add(item);} return (A)this;
    }

    public A removeFromTitles(String... items){
            for (String item : items) {this.Titles.remove(item);} return (A)this;
    }

    public List<String> getTitles(){
            return this.Titles;
    }

    public A withTitles(List<String> Titles){
            this.Titles.clear();
            if (Titles != null) {for (String item : Titles){this.addToTitles(item);}} return (A) this;
    }

    public A withTitles(String... Titles){
            this.Titles.clear(); if (Titles != null) {for (String item :Titles){ this.addToTitles(item);}} return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerProcessListFluentImpl that = (ContainerProcessListFluentImpl) o;
            if (Processes != null ? !Processes.equals(that.Processes) :that.Processes != null) return false;
            if (Titles != null ? !Titles.equals(that.Titles) :that.Titles != null) return false;
            return true;
    }




}
