package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;

public class ContainerJSONBaseFluentImpl<A extends ContainerJSONBaseFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ContainerJSONBaseFluent<A>{

    private String AppArmorProfile;
    private List<String> Args = new ArrayList<String>();
    private String Created;
    private String Driver;
    private String ExecDriver;
    private List<String> ExecIDs = new ArrayList<String>();
    private VisitableBuilder<? extends GraphDriverData,?> GraphDriver;
    private VisitableBuilder<? extends HostConfig,?> HostConfig;
    private String HostnamePath;
    private String HostsPath;
    private String Id;
    private String Image;
    private String LogPath;
    private String MountLabel;
    private String Name;
    private String Path;
    private String ProcessLabel;
    private String ResolvConfPath;
    private Integer RestartCount;
    private Long SizeRootFs;
    private Long SizeRw;
    private VisitableBuilder<? extends ContainerState,?> State;

    public ContainerJSONBaseFluentImpl(){
    }
    public ContainerJSONBaseFluentImpl(ContainerJSONBase instance){
            this.withAppArmorProfile(instance.getAppArmorProfile()); 
            this.withArgs(instance.getArgs()); 
            this.withCreated(instance.getCreated()); 
            this.withDriver(instance.getDriver()); 
            this.withExecDriver(instance.getExecDriver()); 
            this.withExecIDs(instance.getExecIDs()); 
            this.withGraphDriver(instance.getGraphDriver()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.withHostnamePath(instance.getHostnamePath()); 
            this.withHostsPath(instance.getHostsPath()); 
            this.withId(instance.getId()); 
            this.withImage(instance.getImage()); 
            this.withLogPath(instance.getLogPath()); 
            this.withMountLabel(instance.getMountLabel()); 
            this.withName(instance.getName()); 
            this.withPath(instance.getPath()); 
            this.withProcessLabel(instance.getProcessLabel()); 
            this.withResolvConfPath(instance.getResolvConfPath()); 
            this.withRestartCount(instance.getRestartCount()); 
            this.withSizeRootFs(instance.getSizeRootFs()); 
            this.withSizeRw(instance.getSizeRw()); 
            this.withState(instance.getState()); 
    }

    public String getAppArmorProfile(){
            return this.AppArmorProfile;
    }

    public A withAppArmorProfile(String AppArmorProfile){
            this.AppArmorProfile=AppArmorProfile; return (A) this;
    }

    public A addToArgs(String... items){
            for (String item : items) {this.Args.add(item);} return (A)this;
    }

    public A removeFromArgs(String... items){
            for (String item : items) {this.Args.remove(item);} return (A)this;
    }

    public List<String> getArgs(){
            return this.Args;
    }

    public A withArgs(List<String> Args){
            this.Args.clear();
            if (Args != null) {for (String item : Args){this.addToArgs(item);}} return (A) this;
    }

    public A withArgs(String... Args){
            this.Args.clear(); if (Args != null) {for (String item :Args){ this.addToArgs(item);}} return (A) this;
    }

    public String getCreated(){
            return this.Created;
    }

    public A withCreated(String Created){
            this.Created=Created; return (A) this;
    }

    public String getDriver(){
            return this.Driver;
    }

    public A withDriver(String Driver){
            this.Driver=Driver; return (A) this;
    }

    public String getExecDriver(){
            return this.ExecDriver;
    }

    public A withExecDriver(String ExecDriver){
            this.ExecDriver=ExecDriver; return (A) this;
    }

    public A addToExecIDs(String... items){
            for (String item : items) {this.ExecIDs.add(item);} return (A)this;
    }

    public A removeFromExecIDs(String... items){
            for (String item : items) {this.ExecIDs.remove(item);} return (A)this;
    }

    public List<String> getExecIDs(){
            return this.ExecIDs;
    }

    public A withExecIDs(List<String> ExecIDs){
            this.ExecIDs.clear();
            if (ExecIDs != null) {for (String item : ExecIDs){this.addToExecIDs(item);}} return (A) this;
    }

    public A withExecIDs(String... ExecIDs){
            this.ExecIDs.clear(); if (ExecIDs != null) {for (String item :ExecIDs){ this.addToExecIDs(item);}} return (A) this;
    }

    public GraphDriverData getGraphDriver(){
            return this.GraphDriver!=null?this.GraphDriver.build():null;
    }

    public A withGraphDriver(GraphDriverData GraphDriver){
            _visitables.remove(this.GraphDriver);
            if (GraphDriver!=null){ this.GraphDriver= new GraphDriverDataBuilder(GraphDriver); _visitables.add(this.GraphDriver);} return (A) this;
    }

    public ContainerJSONBaseFluent.GraphDriverNested<A> withNewGraphDriver(){
            return new GraphDriverNestedImpl();
    }

    public ContainerJSONBaseFluent.GraphDriverNested<A> withNewGraphDriverLike(GraphDriverData item){
            return new GraphDriverNestedImpl(item);
    }

    public ContainerJSONBaseFluent.GraphDriverNested<A> editGraphDriver(){
            return withNewGraphDriverLike(getGraphDriver());
    }

    public ContainerJSONBaseFluent.GraphDriverNested<A> editOrNewGraphDriver(){
            return withNewGraphDriverLike(getGraphDriver() != null ? getGraphDriver(): new GraphDriverDataBuilder().build());
    }

    public ContainerJSONBaseFluent.GraphDriverNested<A> editOrNewGraphDriverLike(GraphDriverData item){
            return withNewGraphDriverLike(getGraphDriver() != null ? getGraphDriver(): item);
    }

    public HostConfig getHostConfig(){
            return this.HostConfig!=null?this.HostConfig.build():null;
    }

    public A withHostConfig(HostConfig HostConfig){
            _visitables.remove(this.HostConfig);
            if (HostConfig!=null){ this.HostConfig= new HostConfigBuilder(HostConfig); _visitables.add(this.HostConfig);} return (A) this;
    }

    public ContainerJSONBaseFluent.HostConfigNested<A> withNewHostConfig(){
            return new HostConfigNestedImpl();
    }

    public ContainerJSONBaseFluent.HostConfigNested<A> withNewHostConfigLike(HostConfig item){
            return new HostConfigNestedImpl(item);
    }

    public ContainerJSONBaseFluent.HostConfigNested<A> editHostConfig(){
            return withNewHostConfigLike(getHostConfig());
    }

    public ContainerJSONBaseFluent.HostConfigNested<A> editOrNewHostConfig(){
            return withNewHostConfigLike(getHostConfig() != null ? getHostConfig(): new HostConfigBuilder().build());
    }

    public ContainerJSONBaseFluent.HostConfigNested<A> editOrNewHostConfigLike(HostConfig item){
            return withNewHostConfigLike(getHostConfig() != null ? getHostConfig(): item);
    }

    public String getHostnamePath(){
            return this.HostnamePath;
    }

    public A withHostnamePath(String HostnamePath){
            this.HostnamePath=HostnamePath; return (A) this;
    }

    public String getHostsPath(){
            return this.HostsPath;
    }

    public A withHostsPath(String HostsPath){
            this.HostsPath=HostsPath; return (A) this;
    }

    public String getId(){
            return this.Id;
    }

    public A withId(String Id){
            this.Id=Id; return (A) this;
    }

    public String getImage(){
            return this.Image;
    }

    public A withImage(String Image){
            this.Image=Image; return (A) this;
    }

    public String getLogPath(){
            return this.LogPath;
    }

    public A withLogPath(String LogPath){
            this.LogPath=LogPath; return (A) this;
    }

    public String getMountLabel(){
            return this.MountLabel;
    }

    public A withMountLabel(String MountLabel){
            this.MountLabel=MountLabel; return (A) this;
    }

    public String getName(){
            return this.Name;
    }

    public A withName(String Name){
            this.Name=Name; return (A) this;
    }

    public String getPath(){
            return this.Path;
    }

    public A withPath(String Path){
            this.Path=Path; return (A) this;
    }

    public String getProcessLabel(){
            return this.ProcessLabel;
    }

    public A withProcessLabel(String ProcessLabel){
            this.ProcessLabel=ProcessLabel; return (A) this;
    }

    public String getResolvConfPath(){
            return this.ResolvConfPath;
    }

    public A withResolvConfPath(String ResolvConfPath){
            this.ResolvConfPath=ResolvConfPath; return (A) this;
    }

    public Integer getRestartCount(){
            return this.RestartCount;
    }

    public A withRestartCount(Integer RestartCount){
            this.RestartCount=RestartCount; return (A) this;
    }

    public Long getSizeRootFs(){
            return this.SizeRootFs;
    }

    public A withSizeRootFs(Long SizeRootFs){
            this.SizeRootFs=SizeRootFs; return (A) this;
    }

    public Long getSizeRw(){
            return this.SizeRw;
    }

    public A withSizeRw(Long SizeRw){
            this.SizeRw=SizeRw; return (A) this;
    }

    public ContainerState getState(){
            return this.State!=null?this.State.build():null;
    }

    public A withState(ContainerState State){
            _visitables.remove(this.State);
            if (State!=null){ this.State= new ContainerStateBuilder(State); _visitables.add(this.State);} return (A) this;
    }

    public ContainerJSONBaseFluent.StateNested<A> withNewState(){
            return new StateNestedImpl();
    }

    public ContainerJSONBaseFluent.StateNested<A> withNewStateLike(ContainerState item){
            return new StateNestedImpl(item);
    }

    public ContainerJSONBaseFluent.StateNested<A> editState(){
            return withNewStateLike(getState());
    }

    public ContainerJSONBaseFluent.StateNested<A> editOrNewState(){
            return withNewStateLike(getState() != null ? getState(): new ContainerStateBuilder().build());
    }

    public ContainerJSONBaseFluent.StateNested<A> editOrNewStateLike(ContainerState item){
            return withNewStateLike(getState() != null ? getState(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerJSONBaseFluentImpl that = (ContainerJSONBaseFluentImpl) o;
            if (AppArmorProfile != null ? !AppArmorProfile.equals(that.AppArmorProfile) :that.AppArmorProfile != null) return false;
            if (Args != null ? !Args.equals(that.Args) :that.Args != null) return false;
            if (Created != null ? !Created.equals(that.Created) :that.Created != null) return false;
            if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
            if (ExecDriver != null ? !ExecDriver.equals(that.ExecDriver) :that.ExecDriver != null) return false;
            if (ExecIDs != null ? !ExecIDs.equals(that.ExecIDs) :that.ExecIDs != null) return false;
            if (GraphDriver != null ? !GraphDriver.equals(that.GraphDriver) :that.GraphDriver != null) return false;
            if (HostConfig != null ? !HostConfig.equals(that.HostConfig) :that.HostConfig != null) return false;
            if (HostnamePath != null ? !HostnamePath.equals(that.HostnamePath) :that.HostnamePath != null) return false;
            if (HostsPath != null ? !HostsPath.equals(that.HostsPath) :that.HostsPath != null) return false;
            if (Id != null ? !Id.equals(that.Id) :that.Id != null) return false;
            if (Image != null ? !Image.equals(that.Image) :that.Image != null) return false;
            if (LogPath != null ? !LogPath.equals(that.LogPath) :that.LogPath != null) return false;
            if (MountLabel != null ? !MountLabel.equals(that.MountLabel) :that.MountLabel != null) return false;
            if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
            if (Path != null ? !Path.equals(that.Path) :that.Path != null) return false;
            if (ProcessLabel != null ? !ProcessLabel.equals(that.ProcessLabel) :that.ProcessLabel != null) return false;
            if (ResolvConfPath != null ? !ResolvConfPath.equals(that.ResolvConfPath) :that.ResolvConfPath != null) return false;
            if (RestartCount != null ? !RestartCount.equals(that.RestartCount) :that.RestartCount != null) return false;
            if (SizeRootFs != null ? !SizeRootFs.equals(that.SizeRootFs) :that.SizeRootFs != null) return false;
            if (SizeRw != null ? !SizeRw.equals(that.SizeRw) :that.SizeRw != null) return false;
            if (State != null ? !State.equals(that.State) :that.State != null) return false;
            return true;
    }


    public class GraphDriverNestedImpl<N> extends GraphDriverDataFluentImpl<ContainerJSONBaseFluent.GraphDriverNested<N>> implements ContainerJSONBaseFluent.GraphDriverNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final GraphDriverDataBuilder builder;
    
            GraphDriverNestedImpl(GraphDriverData item){
                    this.builder = new GraphDriverDataBuilder(this, item);
            }
            GraphDriverNestedImpl(){
                    this.builder = new GraphDriverDataBuilder(this);
            }
    
    public N and(){
            return (N) ContainerJSONBaseFluentImpl.this.withGraphDriver(builder.build());
    }
    public N endGraphDriver(){
            return and();
    }

}
    public class HostConfigNestedImpl<N> extends HostConfigFluentImpl<ContainerJSONBaseFluent.HostConfigNested<N>> implements ContainerJSONBaseFluent.HostConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final HostConfigBuilder builder;
    
            HostConfigNestedImpl(HostConfig item){
                    this.builder = new HostConfigBuilder(this, item);
            }
            HostConfigNestedImpl(){
                    this.builder = new HostConfigBuilder(this);
            }
    
    public N and(){
            return (N) ContainerJSONBaseFluentImpl.this.withHostConfig(builder.build());
    }
    public N endHostConfig(){
            return and();
    }

}
    public class StateNestedImpl<N> extends ContainerStateFluentImpl<ContainerJSONBaseFluent.StateNested<N>> implements ContainerJSONBaseFluent.StateNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerStateBuilder builder;
    
            StateNestedImpl(ContainerState item){
                    this.builder = new ContainerStateBuilder(this, item);
            }
            StateNestedImpl(){
                    this.builder = new ContainerStateBuilder(this);
            }
    
    public N and(){
            return (N) ContainerJSONBaseFluentImpl.this.withState(builder.build());
    }
    public N endState(){
            return and();
    }

}


}
