package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.docker.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ContainerJSONBaseFluent<A extends ContainerJSONBaseFluent<A>> extends Fluent<A>{


    public String getAppArmorProfile();
    public A withAppArmorProfile(String AppArmorProfile);
    public A addToArgs(String... items);
    public A removeFromArgs(String... items);
    public List<String> getArgs();
    public A withArgs(List<String> Args);
    public A withArgs(String... Args);
    public String getCreated();
    public A withCreated(String Created);
    public String getDriver();
    public A withDriver(String Driver);
    public String getExecDriver();
    public A withExecDriver(String ExecDriver);
    public A addToExecIDs(String... items);
    public A removeFromExecIDs(String... items);
    public List<String> getExecIDs();
    public A withExecIDs(List<String> ExecIDs);
    public A withExecIDs(String... ExecIDs);
    public GraphDriverData getGraphDriver();
    public A withGraphDriver(GraphDriverData GraphDriver);
    public ContainerJSONBaseFluent.GraphDriverNested<A> withNewGraphDriver();
    public ContainerJSONBaseFluent.GraphDriverNested<A> withNewGraphDriverLike(GraphDriverData item);
    public ContainerJSONBaseFluent.GraphDriverNested<A> editGraphDriver();
    public ContainerJSONBaseFluent.GraphDriverNested<A> editOrNewGraphDriver();
    public ContainerJSONBaseFluent.GraphDriverNested<A> editOrNewGraphDriverLike(GraphDriverData item);
    public HostConfig getHostConfig();
    public A withHostConfig(HostConfig HostConfig);
    public ContainerJSONBaseFluent.HostConfigNested<A> withNewHostConfig();
    public ContainerJSONBaseFluent.HostConfigNested<A> withNewHostConfigLike(HostConfig item);
    public ContainerJSONBaseFluent.HostConfigNested<A> editHostConfig();
    public ContainerJSONBaseFluent.HostConfigNested<A> editOrNewHostConfig();
    public ContainerJSONBaseFluent.HostConfigNested<A> editOrNewHostConfigLike(HostConfig item);
    public String getHostnamePath();
    public A withHostnamePath(String HostnamePath);
    public String getHostsPath();
    public A withHostsPath(String HostsPath);
    public String getId();
    public A withId(String Id);
    public String getImage();
    public A withImage(String Image);
    public String getLogPath();
    public A withLogPath(String LogPath);
    public String getMountLabel();
    public A withMountLabel(String MountLabel);
    public String getName();
    public A withName(String Name);
    public String getPath();
    public A withPath(String Path);
    public String getProcessLabel();
    public A withProcessLabel(String ProcessLabel);
    public String getResolvConfPath();
    public A withResolvConfPath(String ResolvConfPath);
    public Integer getRestartCount();
    public A withRestartCount(Integer RestartCount);
    public Long getSizeRootFs();
    public A withSizeRootFs(Long SizeRootFs);
    public Long getSizeRw();
    public A withSizeRw(Long SizeRw);
    public ContainerState getState();
    public A withState(ContainerState State);
    public ContainerJSONBaseFluent.StateNested<A> withNewState();
    public ContainerJSONBaseFluent.StateNested<A> withNewStateLike(ContainerState item);
    public ContainerJSONBaseFluent.StateNested<A> editState();
    public ContainerJSONBaseFluent.StateNested<A> editOrNewState();
    public ContainerJSONBaseFluent.StateNested<A> editOrNewStateLike(ContainerState item);

    public interface GraphDriverNested<N> extends io.fabric8.docker.api.builder.Nested<N>,GraphDriverDataFluent<ContainerJSONBaseFluent.GraphDriverNested<N>>{

        
    public N and();    public N endGraphDriver();
}
    public interface HostConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,HostConfigFluent<ContainerJSONBaseFluent.HostConfigNested<N>>{

        
    public N and();    public N endHostConfig();
}
    public interface StateNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerStateFluent<ContainerJSONBaseFluent.StateNested<N>>{

        
    public N and();    public N endState();
}


}
