package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;

public class ContainerInspectFluentImpl<A extends ContainerInspectFluent<A>> extends ContainerJSONBaseFluentImpl<A> implements ContainerInspectFluent<A>{

    private VisitableBuilder<? extends Config,?> Config;
    private List<VisitableBuilder<? extends MountPoint,?>> Mounts =  new ArrayList<VisitableBuilder<? extends MountPoint,?>>();
    private VisitableBuilder<? extends NetworkSettings,?> NetworkSettings;

    public ContainerInspectFluentImpl(){
    }
    public ContainerInspectFluentImpl(ContainerInspect instance){
            this.withAppArmorProfile(instance.getAppArmorProfile()); 
            this.withArgs(instance.getArgs()); 
            this.withCreated(instance.getCreated()); 
            this.withDriver(instance.getDriver()); 
            this.withExecDriver(instance.getExecDriver()); 
            this.withExecIDs(instance.getExecIDs()); 
            this.withGraphDriver(instance.getGraphDriver()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.withHostnamePath(instance.getHostnamePath()); 
            this.withHostsPath(instance.getHostsPath()); 
            this.withId(instance.getId()); 
            this.withImage(instance.getImage()); 
            this.withLogPath(instance.getLogPath()); 
            this.withMountLabel(instance.getMountLabel()); 
            this.withName(instance.getName()); 
            this.withPath(instance.getPath()); 
            this.withProcessLabel(instance.getProcessLabel()); 
            this.withResolvConfPath(instance.getResolvConfPath()); 
            this.withRestartCount(instance.getRestartCount()); 
            this.withSizeRootFs(instance.getSizeRootFs()); 
            this.withSizeRw(instance.getSizeRw()); 
            this.withState(instance.getState()); 
            this.withConfig(instance.getConfig()); 
            this.withMounts(instance.getMounts()); 
            this.withNetworkSettings(instance.getNetworkSettings()); 
            this.withConfig(instance.getConfig());

            this.withMounts(instance.getMounts());

            this.withNetworkSettings(instance.getNetworkSettings());

    }

    public Config getConfig(){
            return this.Config!=null?this.Config.build():null;
    }

    public A withConfig(Config Config){
            _visitables.remove(this.Config);
            if (Config!=null){ this.Config= new ConfigBuilder(Config); _visitables.add(this.Config);} return (A) this;
    }

    public ContainerInspectFluent.ConfigNested<A> withNewConfig(){
            return new ConfigNestedImpl();
    }

    public ContainerInspectFluent.ConfigNested<A> withNewConfigLike(Config item){
            return new ConfigNestedImpl(item);
    }

    public ContainerInspectFluent.ConfigNested<A> editConfig(){
            return withNewConfigLike(getConfig());
    }

    public ContainerInspectFluent.ConfigNested<A> editOrNewConfig(){
            return withNewConfigLike(getConfig() != null ? getConfig(): new ConfigBuilder().build());
    }

    public ContainerInspectFluent.ConfigNested<A> editOrNewConfigLike(Config item){
            return withNewConfigLike(getConfig() != null ? getConfig(): item);
    }

    public A addToMounts(MountPoint... items){
            for (MountPoint item : items) {MountPointBuilder builder = new MountPointBuilder(item);_visitables.add(builder);this.Mounts.add(builder);} return (A)this;
    }

    public A removeFromMounts(MountPoint... items){
            for (MountPoint item : items) {MountPointBuilder builder = new MountPointBuilder(item);_visitables.remove(builder);this.Mounts.remove(builder);} return (A)this;
    }

    public List<MountPoint> getMounts(){
            return build(Mounts);
    }

    public A withMounts(List<MountPoint> Mounts){
            _visitables.removeAll(this.Mounts);
            this.Mounts.clear();
            if (Mounts != null) {for (MountPoint item : Mounts){this.addToMounts(item);}} return (A) this;
    }

    public A withMounts(MountPoint... Mounts){
            this.Mounts.clear(); if (Mounts != null) {for (MountPoint item :Mounts){ this.addToMounts(item);}} return (A) this;
    }

    public ContainerInspectFluent.MountsNested<A> addNewMount(){
            return new MountsNestedImpl();
    }

    public ContainerInspectFluent.MountsNested<A> addNewMountLike(MountPoint item){
            return new MountsNestedImpl(item);
    }

    public NetworkSettings getNetworkSettings(){
            return this.NetworkSettings!=null?this.NetworkSettings.build():null;
    }

    public A withNetworkSettings(NetworkSettings NetworkSettings){
            _visitables.remove(this.NetworkSettings);
            if (NetworkSettings!=null){ this.NetworkSettings= new NetworkSettingsBuilder(NetworkSettings); _visitables.add(this.NetworkSettings);} return (A) this;
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> withNewNetworkSettings(){
            return new NetworkSettingsNestedImpl();
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> withNewNetworkSettingsLike(NetworkSettings item){
            return new NetworkSettingsNestedImpl(item);
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> editNetworkSettings(){
            return withNewNetworkSettingsLike(getNetworkSettings());
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> editOrNewNetworkSettings(){
            return withNewNetworkSettingsLike(getNetworkSettings() != null ? getNetworkSettings(): new NetworkSettingsBuilder().build());
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> editOrNewNetworkSettingsLike(NetworkSettings item){
            return withNewNetworkSettingsLike(getNetworkSettings() != null ? getNetworkSettings(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerInspectFluentImpl that = (ContainerInspectFluentImpl) o;
            if (Config != null ? !Config.equals(that.Config) :that.Config != null) return false;
            if (Mounts != null ? !Mounts.equals(that.Mounts) :that.Mounts != null) return false;
            if (NetworkSettings != null ? !NetworkSettings.equals(that.NetworkSettings) :that.NetworkSettings != null) return false;
            return true;
    }


    public class ConfigNestedImpl<N> extends ConfigFluentImpl<ContainerInspectFluent.ConfigNested<N>> implements ContainerInspectFluent.ConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ConfigBuilder builder;
    
            ConfigNestedImpl(Config item){
                    this.builder = new ConfigBuilder(this, item);
            }
            ConfigNestedImpl(){
                    this.builder = new ConfigBuilder(this);
            }
    
    public N and(){
            return (N) ContainerInspectFluentImpl.this.withConfig(builder.build());
    }
    public N endConfig(){
            return and();
    }

}
    public class MountsNestedImpl<N> extends MountPointFluentImpl<ContainerInspectFluent.MountsNested<N>> implements ContainerInspectFluent.MountsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final MountPointBuilder builder;
    
            MountsNestedImpl(MountPoint item){
                    this.builder = new MountPointBuilder(this, item);
            }
            MountsNestedImpl(){
                    this.builder = new MountPointBuilder(this);
            }
    
    public N and(){
            return (N) ContainerInspectFluentImpl.this.addToMounts(builder.build());
    }
    public N endMount(){
            return and();
    }

}
    public class NetworkSettingsNestedImpl<N> extends NetworkSettingsFluentImpl<ContainerInspectFluent.NetworkSettingsNested<N>> implements ContainerInspectFluent.NetworkSettingsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkSettingsBuilder builder;
    
            NetworkSettingsNestedImpl(NetworkSettings item){
                    this.builder = new NetworkSettingsBuilder(this, item);
            }
            NetworkSettingsNestedImpl(){
                    this.builder = new NetworkSettingsBuilder(this);
            }
    
    public N and(){
            return (N) ContainerInspectFluentImpl.this.withNetworkSettings(builder.build());
    }
    public N endNetworkSettings(){
            return and();
    }

}


}
