package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ContainerHostConfigBuilder extends ContainerHostConfigFluentImpl<ContainerHostConfigBuilder> implements VisitableBuilder<ContainerHostConfig,ContainerHostConfigBuilder>{

    ContainerHostConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerHostConfigBuilder(){
            this(true);
    }
    public ContainerHostConfigBuilder(Boolean validationEnabled){
            this(new ContainerHostConfig(), validationEnabled);
    }
    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerHostConfig(), validationEnabled);
    }
    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent,ContainerHostConfig instance){
            this(fluent, instance, true);
    }
    public ContainerHostConfigBuilder(ContainerHostConfigFluent<?> fluent,ContainerHostConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNetworkMode(instance.getNetworkMode()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerHostConfigBuilder(ContainerHostConfig instance){
            this(instance,true);
    }
    public ContainerHostConfigBuilder(ContainerHostConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNetworkMode(instance.getNetworkMode()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerHostConfig build(){
            EditableContainerHostConfig buildable = new EditableContainerHostConfig(fluent.getNetworkMode());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerHostConfigBuilder that = (ContainerHostConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
