package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.docker.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import java.lang.Long;
import lombok.ToString;
import java.util.Map;

public interface ContainerFluent<A extends ContainerFluent<A>> extends Fluent<A>{


    public String getId();
    public A withId(String id);
    public A addToNames(String... items);
    public A removeFromNames(String... items);
    public List<String> getNames();
    public A withNames(List<String> names);
    public A withNames(String... names);
    public String getImage();
    public A withImage(String image);
    public String getImageId();
    public A withImageId(String imageId);
    public String getCommand();
    public A withCommand(String command);
    public Long getCreated();
    public A withCreated(Long created);
    public A addToPorts(Port... items);
    public A removeFromPorts(Port... items);
    public List<Port> getPorts();
    public A withPorts(List<Port> ports);
    public A withPorts(Port... ports);
    public ContainerFluent.PortsNested<A> addNewPort();
    public ContainerFluent.PortsNested<A> addNewPortLike(Port item);
    public A addNewPort(String IP,Integer PrivatePort,Integer PublicPort,String Type);
    public Long getSizeRw();
    public A withSizeRw(Long sizeRw);
    public Long getSizeRootFs();
    public A withSizeRootFs(Long sizeRootFs);
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public String getStatus();
    public A withStatus(String status);
    public ContainerHostConfig getHostConfig();
    public A withHostConfig(ContainerHostConfig hostConfig);
    public ContainerFluent.HostConfigNested<A> withNewHostConfig();
    public ContainerFluent.HostConfigNested<A> withNewHostConfigLike(ContainerHostConfig item);
    public ContainerFluent.HostConfigNested<A> editHostConfig();
    public ContainerFluent.HostConfigNested<A> editOrNewHostConfig();
    public ContainerFluent.HostConfigNested<A> editOrNewHostConfigLike(ContainerHostConfig item);
    public A withNewHostConfig(String networkMode);
    public NetworkSettings getSummaryNetworkSettings();
    public A withSummaryNetworkSettings(NetworkSettings summaryNetworkSettings);
    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettings();
    public ContainerFluent.SummaryNetworkSettingsNested<A> withNewSummaryNetworkSettingsLike(NetworkSettings item);
    public ContainerFluent.SummaryNetworkSettingsNested<A> editSummaryNetworkSettings();
    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettings();
    public ContainerFluent.SummaryNetworkSettingsNested<A> editOrNewSummaryNetworkSettingsLike(NetworkSettings item);

    public interface PortsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,PortFluent<ContainerFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}
    public interface HostConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,ContainerHostConfigFluent<ContainerFluent.HostConfigNested<N>>{

        
    public N and();    public N endHostConfig();
}
    public interface SummaryNetworkSettingsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,NetworkSettingsFluent<ContainerFluent.SummaryNetworkSettingsNested<N>>{

        
    public N and();    public N endSummaryNetworkSettings();
}


}
