package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public class ContainerCreateRequestFluentImpl<A extends ContainerCreateRequestFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ContainerCreateRequestFluent<A>{

    private String name;
    private String hostname;
    private String domainname;
    private String user;
    private String memory;
    private String memorySwap;
    private String memoryReservation;
    private String kernelMemory;
    private String cpuShares;
    private String cpuPeriod;
    private String cpuQuota;
    private String cpuset;
    private String cpusetCpus;
    private String cpusetMems;
    private Integer blkioWeight;
    private Integer memorySwappiness;
    private Boolean oomKillDisable;
    private Boolean attachStdin;
    private Boolean attachStdout;
    private Boolean attachStderr;
    private Boolean tty;
    private Boolean openStdin;
    private Boolean stdinOnce;
    private Map<String,String> env = new LinkedHashMap<String,String>();
    private List<String> cmd = new ArrayList<String>();
    private String entrypoint;
    private String image;
    private Map<String,String> labels = new LinkedHashMap<String,String>();
    private Map<String,String> mounts = new LinkedHashMap<String,String>();
    private String workingDir;
    private Boolean networkDisabled;
    private String macAddress;
    private Map<Integer,Protocol> exposedPorts = new LinkedHashMap<Integer,Protocol>();
    private String stopSignal;
    private VisitableBuilder<? extends HostConfig,?> hostConfig;

    public ContainerCreateRequestFluentImpl(){
    }
    public ContainerCreateRequestFluentImpl(ContainerCreateRequest instance){
            this.withName(instance.getName()); 
            this.withCpuset(instance.getCpuset()); 
            this.withHostname(instance.getHostname()); 
            this.withDomainname(instance.getDomainname()); 
            this.withUser(instance.getUser()); 
            this.withMemory(instance.getMemory()); 
            this.withMemorySwap(instance.getMemorySwap()); 
            this.withMemoryReservation(instance.getMemoryReservation()); 
            this.withKernelMemory(instance.getKernelMemory()); 
            this.withCpuShares(instance.getCpuShares()); 
            this.withCpuPeriod(instance.getCpuPeriod()); 
            this.withCpuQuota(instance.getCpuQuota()); 
            this.withCpusetCpus(instance.getCpusetCpus()); 
            this.withCpusetMems(instance.getCpusetMems()); 
            this.withBlkioWeight(instance.getBlkioWeight()); 
            this.withMemorySwappiness(instance.getMemorySwappiness()); 
            this.withOomKillDisable(instance.getOomKillDisable()); 
            this.withAttachStdin(instance.getAttachStdin()); 
            this.withAttachStdout(instance.getAttachStdout()); 
            this.withAttachStderr(instance.getAttachStderr()); 
            this.withTty(instance.getTty()); 
            this.withOpenStdin(instance.getOpenStdin()); 
            this.withStdinOnce(instance.getStdinOnce()); 
            this.withEnv(instance.getEnv()); 
            this.withCmd(instance.getCmd()); 
            this.withEntrypoint(instance.getEntrypoint()); 
            this.withImage(instance.getImage()); 
            this.withLabels(instance.getLabels()); 
            this.withMounts(instance.getMounts()); 
            this.withWorkingDir(instance.getWorkingDir()); 
            this.withNetworkDisabled(instance.getNetworkDisabled()); 
            this.withMacAddress(instance.getMacAddress()); 
            this.withExposedPorts(instance.getExposedPorts()); 
            this.withStopSignal(instance.getStopSignal()); 
            this.withHostConfig(instance.getHostConfig()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public String getHostname(){
            return this.hostname;
    }

    public A withHostname(String hostname){
            this.hostname=hostname; return (A) this;
    }

    public String getDomainname(){
            return this.domainname;
    }

    public A withDomainname(String domainname){
            this.domainname=domainname; return (A) this;
    }

    public String getUser(){
            return this.user;
    }

    public A withUser(String user){
            this.user=user; return (A) this;
    }

    public String getMemory(){
            return this.memory;
    }

    public A withMemory(String memory){
            this.memory=memory; return (A) this;
    }

    public String getMemorySwap(){
            return this.memorySwap;
    }

    public A withMemorySwap(String memorySwap){
            this.memorySwap=memorySwap; return (A) this;
    }

    public String getMemoryReservation(){
            return this.memoryReservation;
    }

    public A withMemoryReservation(String memoryReservation){
            this.memoryReservation=memoryReservation; return (A) this;
    }

    public String getKernelMemory(){
            return this.kernelMemory;
    }

    public A withKernelMemory(String kernelMemory){
            this.kernelMemory=kernelMemory; return (A) this;
    }

    public String getCpuShares(){
            return this.cpuShares;
    }

    public A withCpuShares(String cpuShares){
            this.cpuShares=cpuShares; return (A) this;
    }

    public String getCpuPeriod(){
            return this.cpuPeriod;
    }

    public A withCpuPeriod(String cpuPeriod){
            this.cpuPeriod=cpuPeriod; return (A) this;
    }

    public String getCpuQuota(){
            return this.cpuQuota;
    }

    public A withCpuQuota(String cpuQuota){
            this.cpuQuota=cpuQuota; return (A) this;
    }

    public String getCpuset(){
            return this.cpuset;
    }

    public A withCpuset(String cpuset){
            this.cpuset=cpuset; return (A) this;
    }

    public String getCpusetCpus(){
            return this.cpusetCpus;
    }

    public A withCpusetCpus(String cpusetCpus){
            this.cpusetCpus=cpusetCpus; return (A) this;
    }

    public String getCpusetMems(){
            return this.cpusetMems;
    }

    public A withCpusetMems(String cpusetMems){
            this.cpusetMems=cpusetMems; return (A) this;
    }

    public Integer getBlkioWeight(){
            return this.blkioWeight;
    }

    public A withBlkioWeight(Integer blkioWeight){
            this.blkioWeight=blkioWeight; return (A) this;
    }

    public Integer getMemorySwappiness(){
            return this.memorySwappiness;
    }

    public A withMemorySwappiness(Integer memorySwappiness){
            this.memorySwappiness=memorySwappiness; return (A) this;
    }

    public Boolean isOomKillDisable(){
            return this.oomKillDisable;
    }

    public A withOomKillDisable(Boolean oomKillDisable){
            this.oomKillDisable=oomKillDisable; return (A) this;
    }

    public Boolean isAttachStdin(){
            return this.attachStdin;
    }

    public A withAttachStdin(Boolean attachStdin){
            this.attachStdin=attachStdin; return (A) this;
    }

    public Boolean isAttachStdout(){
            return this.attachStdout;
    }

    public A withAttachStdout(Boolean attachStdout){
            this.attachStdout=attachStdout; return (A) this;
    }

    public Boolean isAttachStderr(){
            return this.attachStderr;
    }

    public A withAttachStderr(Boolean attachStderr){
            this.attachStderr=attachStderr; return (A) this;
    }

    public Boolean isTty(){
            return this.tty;
    }

    public A withTty(Boolean tty){
            this.tty=tty; return (A) this;
    }

    public Boolean isOpenStdin(){
            return this.openStdin;
    }

    public A withOpenStdin(Boolean openStdin){
            this.openStdin=openStdin; return (A) this;
    }

    public Boolean isStdinOnce(){
            return this.stdinOnce;
    }

    public A withStdinOnce(Boolean stdinOnce){
            this.stdinOnce=stdinOnce; return (A) this;
    }

    public A addToEnv(String key,String value){
            if(key != null && value != null) {this.env.put(key, value);} return (A)this;
    }

    public A addToEnv(Map<String,String> map){
            if(map != null) { this.env.putAll(map);} return (A)this;
    }

    public A removeFromEnv(String key){
            if(key != null) {this.env.remove(key);} return (A)this;
    }

    public A removeFromEnv(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.env.remove(key);}} return (A)this;
    }

    public Map<String,String> getEnv(){
            return this.env;
    }

    public A withEnv(Map<String,String> env){
            this.env.clear();
            if (env != null) {this.env.putAll(env);} return (A) this;
    }

    public A addToCmd(String... items){
            for (String item : items) {this.cmd.add(item);} return (A)this;
    }

    public A removeFromCmd(String... items){
            for (String item : items) {this.cmd.remove(item);} return (A)this;
    }

    public List<String> getCmd(){
            return this.cmd;
    }

    public A withCmd(List<String> cmd){
            this.cmd.clear();
            if (cmd != null) {for (String item : cmd){this.addToCmd(item);}} return (A) this;
    }

    public A withCmd(String... cmd){
            this.cmd.clear(); if (cmd != null) {for (String item :cmd){ this.addToCmd(item);}} return (A) this;
    }

    public String getEntrypoint(){
            return this.entrypoint;
    }

    public A withEntrypoint(String entrypoint){
            this.entrypoint=entrypoint; return (A) this;
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public A addToLabels(String key,String value){
            if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(key != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.labels.remove(key);}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.labels;
    }

    public A withLabels(Map<String,String> labels){
            this.labels.clear();
            if (labels != null) {this.labels.putAll(labels);} return (A) this;
    }

    public A addToMounts(String key,String value){
            if(key != null && value != null) {this.mounts.put(key, value);} return (A)this;
    }

    public A addToMounts(Map<String,String> map){
            if(map != null) { this.mounts.putAll(map);} return (A)this;
    }

    public A removeFromMounts(String key){
            if(key != null) {this.mounts.remove(key);} return (A)this;
    }

    public A removeFromMounts(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.mounts.remove(key);}} return (A)this;
    }

    public Map<String,String> getMounts(){
            return this.mounts;
    }

    public A withMounts(Map<String,String> mounts){
            this.mounts.clear();
            if (mounts != null) {this.mounts.putAll(mounts);} return (A) this;
    }

    public String getWorkingDir(){
            return this.workingDir;
    }

    public A withWorkingDir(String workingDir){
            this.workingDir=workingDir; return (A) this;
    }

    public Boolean isNetworkDisabled(){
            return this.networkDisabled;
    }

    public A withNetworkDisabled(Boolean networkDisabled){
            this.networkDisabled=networkDisabled; return (A) this;
    }

    public String getMacAddress(){
            return this.macAddress;
    }

    public A withMacAddress(String macAddress){
            this.macAddress=macAddress; return (A) this;
    }

    public A addToExposedPorts(Integer key,Protocol value){
            if(key != null && value != null) {this.exposedPorts.put(key, value);} return (A)this;
    }

    public A addToExposedPorts(Map<Integer,Protocol> map){
            if(map != null) { this.exposedPorts.putAll(map);} return (A)this;
    }

    public A removeFromExposedPorts(Integer key){
            if(key != null) {this.exposedPorts.remove(key);} return (A)this;
    }

    public A removeFromExposedPorts(Map<Integer,Protocol> map){
            if(map != null) { for(Object key : map.keySet()) {this.exposedPorts.remove(key);}} return (A)this;
    }

    public Map<Integer,Protocol> getExposedPorts(){
            return this.exposedPorts;
    }

    public A withExposedPorts(Map<Integer,Protocol> exposedPorts){
            this.exposedPorts.clear();
            if (exposedPorts != null) {this.exposedPorts.putAll(exposedPorts);} return (A) this;
    }

    public String getStopSignal(){
            return this.stopSignal;
    }

    public A withStopSignal(String stopSignal){
            this.stopSignal=stopSignal; return (A) this;
    }

    public HostConfig getHostConfig(){
            return this.hostConfig!=null?this.hostConfig.build():null;
    }

    public A withHostConfig(HostConfig hostConfig){
            _visitables.remove(this.hostConfig);
            if (hostConfig!=null){ this.hostConfig= new HostConfigBuilder(hostConfig); _visitables.add(this.hostConfig);} return (A) this;
    }

    public ContainerCreateRequestFluent.HostConfigNested<A> withNewHostConfig(){
            return new HostConfigNestedImpl();
    }

    public ContainerCreateRequestFluent.HostConfigNested<A> withNewHostConfigLike(HostConfig item){
            return new HostConfigNestedImpl(item);
    }

    public ContainerCreateRequestFluent.HostConfigNested<A> editHostConfig(){
            return withNewHostConfigLike(getHostConfig());
    }

    public ContainerCreateRequestFluent.HostConfigNested<A> editOrNewHostConfig(){
            return withNewHostConfigLike(getHostConfig() != null ? getHostConfig(): new HostConfigBuilder().build());
    }

    public ContainerCreateRequestFluent.HostConfigNested<A> editOrNewHostConfigLike(HostConfig item){
            return withNewHostConfigLike(getHostConfig() != null ? getHostConfig(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerCreateRequestFluentImpl that = (ContainerCreateRequestFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
            if (domainname != null ? !domainname.equals(that.domainname) :that.domainname != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            if (memory != null ? !memory.equals(that.memory) :that.memory != null) return false;
            if (memorySwap != null ? !memorySwap.equals(that.memorySwap) :that.memorySwap != null) return false;
            if (memoryReservation != null ? !memoryReservation.equals(that.memoryReservation) :that.memoryReservation != null) return false;
            if (kernelMemory != null ? !kernelMemory.equals(that.kernelMemory) :that.kernelMemory != null) return false;
            if (cpuShares != null ? !cpuShares.equals(that.cpuShares) :that.cpuShares != null) return false;
            if (cpuPeriod != null ? !cpuPeriod.equals(that.cpuPeriod) :that.cpuPeriod != null) return false;
            if (cpuQuota != null ? !cpuQuota.equals(that.cpuQuota) :that.cpuQuota != null) return false;
            if (cpuset != null ? !cpuset.equals(that.cpuset) :that.cpuset != null) return false;
            if (cpusetCpus != null ? !cpusetCpus.equals(that.cpusetCpus) :that.cpusetCpus != null) return false;
            if (cpusetMems != null ? !cpusetMems.equals(that.cpusetMems) :that.cpusetMems != null) return false;
            if (blkioWeight != null ? !blkioWeight.equals(that.blkioWeight) :that.blkioWeight != null) return false;
            if (memorySwappiness != null ? !memorySwappiness.equals(that.memorySwappiness) :that.memorySwappiness != null) return false;
            if (oomKillDisable != null ? !oomKillDisable.equals(that.oomKillDisable) :that.oomKillDisable != null) return false;
            if (attachStdin != null ? !attachStdin.equals(that.attachStdin) :that.attachStdin != null) return false;
            if (attachStdout != null ? !attachStdout.equals(that.attachStdout) :that.attachStdout != null) return false;
            if (attachStderr != null ? !attachStderr.equals(that.attachStderr) :that.attachStderr != null) return false;
            if (tty != null ? !tty.equals(that.tty) :that.tty != null) return false;
            if (openStdin != null ? !openStdin.equals(that.openStdin) :that.openStdin != null) return false;
            if (stdinOnce != null ? !stdinOnce.equals(that.stdinOnce) :that.stdinOnce != null) return false;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (cmd != null ? !cmd.equals(that.cmd) :that.cmd != null) return false;
            if (entrypoint != null ? !entrypoint.equals(that.entrypoint) :that.entrypoint != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
            if (mounts != null ? !mounts.equals(that.mounts) :that.mounts != null) return false;
            if (workingDir != null ? !workingDir.equals(that.workingDir) :that.workingDir != null) return false;
            if (networkDisabled != null ? !networkDisabled.equals(that.networkDisabled) :that.networkDisabled != null) return false;
            if (macAddress != null ? !macAddress.equals(that.macAddress) :that.macAddress != null) return false;
            if (exposedPorts != null ? !exposedPorts.equals(that.exposedPorts) :that.exposedPorts != null) return false;
            if (stopSignal != null ? !stopSignal.equals(that.stopSignal) :that.stopSignal != null) return false;
            if (hostConfig != null ? !hostConfig.equals(that.hostConfig) :that.hostConfig != null) return false;
            return true;
    }


    public class HostConfigNestedImpl<N> extends HostConfigFluentImpl<ContainerCreateRequestFluent.HostConfigNested<N>> implements ContainerCreateRequestFluent.HostConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final HostConfigBuilder builder;
    
            HostConfigNestedImpl(HostConfig item){
                    this.builder = new HostConfigBuilder(this, item);
            }
            HostConfigNestedImpl(){
                    this.builder = new HostConfigBuilder(this);
            }
    
    public N and(){
            return (N) ContainerCreateRequestFluentImpl.this.withHostConfig(builder.build());
    }
    public N endHostConfig(){
            return and();
    }

}


}
