package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import io.fabric8.docker.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.docker.api.builder.Nested;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.lang.Integer;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface ContainerCreateRequestFluent<A extends ContainerCreateRequestFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public String getHostname();
    public A withHostname(String hostname);
    public String getDomainname();
    public A withDomainname(String domainname);
    public String getUser();
    public A withUser(String user);
    public String getMemory();
    public A withMemory(String memory);
    public String getMemorySwap();
    public A withMemorySwap(String memorySwap);
    public String getMemoryReservation();
    public A withMemoryReservation(String memoryReservation);
    public String getKernelMemory();
    public A withKernelMemory(String kernelMemory);
    public String getCpuShares();
    public A withCpuShares(String cpuShares);
    public String getCpuPeriod();
    public A withCpuPeriod(String cpuPeriod);
    public String getCpuQuota();
    public A withCpuQuota(String cpuQuota);
    public String getCpuset();
    public A withCpuset(String cpuset);
    public String getCpusetCpus();
    public A withCpusetCpus(String cpusetCpus);
    public String getCpusetMems();
    public A withCpusetMems(String cpusetMems);
    public Integer getBlkioWeight();
    public A withBlkioWeight(Integer blkioWeight);
    public Integer getMemorySwappiness();
    public A withMemorySwappiness(Integer memorySwappiness);
    public Boolean isOomKillDisable();
    public A withOomKillDisable(Boolean oomKillDisable);
    public Boolean isAttachStdin();
    public A withAttachStdin(Boolean attachStdin);
    public Boolean isAttachStdout();
    public A withAttachStdout(Boolean attachStdout);
    public Boolean isAttachStderr();
    public A withAttachStderr(Boolean attachStderr);
    public Boolean isTty();
    public A withTty(Boolean tty);
    public Boolean isOpenStdin();
    public A withOpenStdin(Boolean openStdin);
    public Boolean isStdinOnce();
    public A withStdinOnce(Boolean stdinOnce);
    public A addToEnv(String key,String value);
    public A addToEnv(Map<String,String> map);
    public A removeFromEnv(String key);
    public A removeFromEnv(Map<String,String> map);
    public Map<String,String> getEnv();
    public A withEnv(Map<String,String> env);
    public A addToCmd(String... items);
    public A removeFromCmd(String... items);
    public List<String> getCmd();
    public A withCmd(List<String> cmd);
    public A withCmd(String... cmd);
    public String getEntrypoint();
    public A withEntrypoint(String entrypoint);
    public String getImage();
    public A withImage(String image);
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public A addToMounts(String key,String value);
    public A addToMounts(Map<String,String> map);
    public A removeFromMounts(String key);
    public A removeFromMounts(Map<String,String> map);
    public Map<String,String> getMounts();
    public A withMounts(Map<String,String> mounts);
    public String getWorkingDir();
    public A withWorkingDir(String workingDir);
    public Boolean isNetworkDisabled();
    public A withNetworkDisabled(Boolean networkDisabled);
    public String getMacAddress();
    public A withMacAddress(String macAddress);
    public A addToExposedPorts(Integer key,Protocol value);
    public A addToExposedPorts(Map<Integer,Protocol> map);
    public A removeFromExposedPorts(Integer key);
    public A removeFromExposedPorts(Map<Integer,Protocol> map);
    public Map<Integer,Protocol> getExposedPorts();
    public A withExposedPorts(Map<Integer,Protocol> exposedPorts);
    public String getStopSignal();
    public A withStopSignal(String stopSignal);
    public HostConfig getHostConfig();
    public A withHostConfig(HostConfig hostConfig);
    public ContainerCreateRequestFluent.HostConfigNested<A> withNewHostConfig();
    public ContainerCreateRequestFluent.HostConfigNested<A> withNewHostConfigLike(HostConfig item);
    public ContainerCreateRequestFluent.HostConfigNested<A> editHostConfig();
    public ContainerCreateRequestFluent.HostConfigNested<A> editOrNewHostConfig();
    public ContainerCreateRequestFluent.HostConfigNested<A> editOrNewHostConfigLike(HostConfig item);

    public interface HostConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,HostConfigFluent<ContainerCreateRequestFluent.HostConfigNested<N>>{

        
    public N and();    public N endHostConfig();
}


}
