package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ContainerCreateRequestBuilder extends ContainerCreateRequestFluentImpl<ContainerCreateRequestBuilder> implements VisitableBuilder<ContainerCreateRequest,ContainerCreateRequestBuilder>{

    ContainerCreateRequestFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerCreateRequestBuilder(){
            this(true);
    }
    public ContainerCreateRequestBuilder(Boolean validationEnabled){
            this.fluent = this; this.validationEnabled=validationEnabled;
    }
    public ContainerCreateRequestBuilder(ContainerCreateRequestFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerCreateRequestBuilder(ContainerCreateRequestFluent<?> fluent,Boolean validationEnabled){
            this.fluent = fluent; this.validationEnabled=validationEnabled;
    }
    public ContainerCreateRequestBuilder(ContainerCreateRequestFluent<?> fluent,ContainerCreateRequest instance){
            this(fluent, instance, true);
    }
    public ContainerCreateRequestBuilder(ContainerCreateRequestFluent<?> fluent,ContainerCreateRequest instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withCpuset(instance.getCpuset()); 
            fluent.withHostname(instance.getHostname()); 
            fluent.withDomainname(instance.getDomainname()); 
            fluent.withUser(instance.getUser()); 
            fluent.withMemory(instance.getMemory()); 
            fluent.withMemorySwap(instance.getMemorySwap()); 
            fluent.withMemoryReservation(instance.getMemoryReservation()); 
            fluent.withKernelMemory(instance.getKernelMemory()); 
            fluent.withCpuShares(instance.getCpuShares()); 
            fluent.withCpuPeriod(instance.getCpuPeriod()); 
            fluent.withCpuQuota(instance.getCpuQuota()); 
            fluent.withCpusetCpus(instance.getCpusetCpus()); 
            fluent.withCpusetMems(instance.getCpusetMems()); 
            fluent.withBlkioWeight(instance.getBlkioWeight()); 
            fluent.withMemorySwappiness(instance.getMemorySwappiness()); 
            fluent.withOomKillDisable(instance.getOomKillDisable()); 
            fluent.withAttachStdin(instance.getAttachStdin()); 
            fluent.withAttachStdout(instance.getAttachStdout()); 
            fluent.withAttachStderr(instance.getAttachStderr()); 
            fluent.withTty(instance.getTty()); 
            fluent.withOpenStdin(instance.getOpenStdin()); 
            fluent.withStdinOnce(instance.getStdinOnce()); 
            fluent.withEnv(instance.getEnv()); 
            fluent.withCmd(instance.getCmd()); 
            fluent.withEntrypoint(instance.getEntrypoint()); 
            fluent.withImage(instance.getImage()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withMounts(instance.getMounts()); 
            fluent.withWorkingDir(instance.getWorkingDir()); 
            fluent.withNetworkDisabled(instance.getNetworkDisabled()); 
            fluent.withMacAddress(instance.getMacAddress()); 
            fluent.withExposedPorts(instance.getExposedPorts()); 
            fluent.withStopSignal(instance.getStopSignal()); 
            fluent.withHostConfig(instance.getHostConfig()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerCreateRequestBuilder(ContainerCreateRequest instance){
            this(instance,true);
    }
    public ContainerCreateRequestBuilder(ContainerCreateRequest instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withCpuset(instance.getCpuset()); 
            this.withHostname(instance.getHostname()); 
            this.withDomainname(instance.getDomainname()); 
            this.withUser(instance.getUser()); 
            this.withMemory(instance.getMemory()); 
            this.withMemorySwap(instance.getMemorySwap()); 
            this.withMemoryReservation(instance.getMemoryReservation()); 
            this.withKernelMemory(instance.getKernelMemory()); 
            this.withCpuShares(instance.getCpuShares()); 
            this.withCpuPeriod(instance.getCpuPeriod()); 
            this.withCpuQuota(instance.getCpuQuota()); 
            this.withCpusetCpus(instance.getCpusetCpus()); 
            this.withCpusetMems(instance.getCpusetMems()); 
            this.withBlkioWeight(instance.getBlkioWeight()); 
            this.withMemorySwappiness(instance.getMemorySwappiness()); 
            this.withOomKillDisable(instance.getOomKillDisable()); 
            this.withAttachStdin(instance.getAttachStdin()); 
            this.withAttachStdout(instance.getAttachStdout()); 
            this.withAttachStderr(instance.getAttachStderr()); 
            this.withTty(instance.getTty()); 
            this.withOpenStdin(instance.getOpenStdin()); 
            this.withStdinOnce(instance.getStdinOnce()); 
            this.withEnv(instance.getEnv()); 
            this.withCmd(instance.getCmd()); 
            this.withEntrypoint(instance.getEntrypoint()); 
            this.withImage(instance.getImage()); 
            this.withLabels(instance.getLabels()); 
            this.withMounts(instance.getMounts()); 
            this.withWorkingDir(instance.getWorkingDir()); 
            this.withNetworkDisabled(instance.getNetworkDisabled()); 
            this.withMacAddress(instance.getMacAddress()); 
            this.withExposedPorts(instance.getExposedPorts()); 
            this.withStopSignal(instance.getStopSignal()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerCreateRequest build(){
            EditableContainerCreateRequest buildable = new EditableContainerCreateRequest(fluent.getName(),fluent.getCpuset(),fluent.getHostname(),fluent.getDomainname(),fluent.getUser(),fluent.getMemory(),fluent.getMemorySwap(),fluent.getMemoryReservation(),fluent.getKernelMemory(),fluent.getCpuShares(),fluent.getCpuPeriod(),fluent.getCpuQuota(),fluent.getCpusetCpus(),fluent.getCpusetMems(),fluent.getBlkioWeight(),fluent.getMemorySwappiness(),fluent.isOomKillDisable(),fluent.isAttachStdin(),fluent.isAttachStdout(),fluent.isAttachStderr(),fluent.isTty(),fluent.isOpenStdin(),fluent.isStdinOnce(),fluent.getEnv(),fluent.getCmd(),fluent.getEntrypoint(),fluent.getImage(),fluent.getLabels(),fluent.getMounts(),fluent.getWorkingDir(),fluent.isNetworkDisabled(),fluent.getMacAddress(),fluent.getExposedPorts(),fluent.getStopSignal(),fluent.getHostConfig());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerCreateRequestBuilder that = (ContainerCreateRequestBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
