package io.fabric8.docker.api.model;

import javax.validation.Validation;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ContainerChangeBuilder extends ContainerChangeFluentImpl<ContainerChangeBuilder> implements VisitableBuilder<ContainerChange,ContainerChangeBuilder>{

    ContainerChangeFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerChangeBuilder(){
            this(true);
    }
    public ContainerChangeBuilder(Boolean validationEnabled){
            this(new ContainerChange(), validationEnabled);
    }
    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerChange(), validationEnabled);
    }
    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent,ContainerChange instance){
            this(fluent, instance, true);
    }
    public ContainerChangeBuilder(ContainerChangeFluent<?> fluent,ContainerChange instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKind(instance.getKind()); 
            fluent.withPath(instance.getPath()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerChangeBuilder(ContainerChange instance){
            this(instance,true);
    }
    public ContainerChangeBuilder(ContainerChange instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKind(instance.getKind()); 
            this.withPath(instance.getPath()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerChange build(){
            EditableContainerChange buildable = new EditableContainerChange(fluent.getKind(),fluent.getPath());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerChangeBuilder that = (ContainerChangeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
